/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlacklistConfig;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IRegistryFilter;
import mcp.mobius.waila.util.Log;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class BlacklistConfig {
    private static final Log LOG = Log.create();
    private static final String BLACKLIST_TAG = "#" + String.valueOf(Waila.id("blacklist"));
    public static final int VERSION = 0;
    public static final IJsonConfig.Commenter COMMENTER = p -> !p.isEmpty() ? null : "Run `/waila reload` to apply changes server-wide.\nRun `/wailac reload` to apply changes to only your client.\n\n%s\n\nThe `%s` tag rule can not be removed".formatted(IRegistryFilter.getHeader(), BLACKLIST_TAG);
    public final LinkedHashSet<String> blocks = new LinkedHashSet();
    public final LinkedHashSet<String> blockEntityTypes = new LinkedHashSet();
    public final LinkedHashSet<String> entityTypes = new LinkedHashSet();
    @IJsonConfig.Comment(value="\nThe values below are used internally by WTHIT, you SHOULD NOT modify it!")
    private int configVersion = 0;
    public int[] pluginHash = new int[]{0, 0, 0};
    @Nullable
    private transient View view;

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    public void addBlacklistTags() {
        this.blocks.add(BLACKLIST_TAG);
        this.blockEntityTypes.add(BLACKLIST_TAG);
        this.entityTypes.add(BLACKLIST_TAG);
    }

    public View getView() {
        if (this.view == null) {
            this.view = new View();
        }
        return this.view;
    }

    public class View
    implements IBlacklistConfig {
        public final IRegistryFilter<Block> blockFilter;
        public final IRegistryFilter<BlockEntityType<?>> blockEntityFilter;
        public final IRegistryFilter<EntityType<?>> entityFilter;
        @Nullable
        private IRegistryFilter<Block> syncedBlockFilter = null;
        @Nullable
        private IRegistryFilter<BlockEntityType<?>> syncedBlockEntityFilter = null;
        @Nullable
        private IRegistryFilter<EntityType<?>> syncedEntityFilter = null;

        private View() {
            this.blockFilter = IRegistryFilter.of(Registries.BLOCK).parse(BlacklistConfig.this.blocks).build();
            this.blockEntityFilter = IRegistryFilter.of(Registries.BLOCK_ENTITY_TYPE).parse(BlacklistConfig.this.blockEntityTypes).build();
            this.entityFilter = IRegistryFilter.of(Registries.ENTITY_TYPE).parse(BlacklistConfig.this.entityTypes).build();
        }

        public void sync(Set<String> blockRules, Set<String> blockEntityRules, Set<String> entityRules) {
            this.syncedBlockFilter = View.sync(Registries.BLOCK, BlacklistConfig.this.blocks, blockRules);
            this.syncedBlockEntityFilter = View.sync(Registries.BLOCK_ENTITY_TYPE, BlacklistConfig.this.blockEntityTypes, blockEntityRules);
            this.syncedEntityFilter = View.sync(Registries.ENTITY_TYPE, BlacklistConfig.this.entityTypes, entityRules);
        }

        private static <T> IRegistryFilter<T> sync(ResourceKey<? extends Registry<T>> registryKey, Set<String> localRules, Set<String> syncedRules) {
            LOG.debug("Syncing blacklist {}", registryKey.location());
            return IRegistryFilter.of(registryKey).parse((String[])syncedRules.stream().filter(it -> !localRules.contains(it)).toArray(String[]::new)).build();
        }

        @Override
        public boolean contains(Block block) {
            return this.blockFilter.matches(block) || this.syncedBlockFilter != null && this.syncedBlockFilter.matches(block);
        }

        @Override
        public boolean contains(BlockEntity blockEntity) {
            BlockEntityType type = blockEntity.getType();
            return this.blockEntityFilter.matches(type) || this.syncedBlockEntityFilter != null && this.syncedBlockEntityFilter.matches(type);
        }

        @Override
        public boolean contains(Entity entity) {
            EntityType type = entity.getType();
            return this.entityFilter.matches(type) || this.syncedEntityFilter != null && this.syncedEntityFilter.matches(type);
        }
    }

    public static class Adapter
    implements JsonSerializer<BlacklistConfig>,
    JsonDeserializer<BlacklistConfig> {
        public JsonElement serialize(BlacklistConfig src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            src.addBlacklistTags();
            object.add("blocks", context.serialize(src.blocks));
            object.add("blockEntityTypes", context.serialize(src.blockEntityTypes));
            object.add("entityTypes", context.serialize(src.entityTypes));
            object.addProperty("configVersion", (Number)src.configVersion);
            object.add("pluginHash", context.serialize((Object)src.pluginHash));
            return object;
        }

        public BlacklistConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            BlacklistConfig res = new BlacklistConfig();
            this.deserializeEntries(res.blocks, object.getAsJsonArray("blocks"));
            this.deserializeEntries(res.blockEntityTypes, object.getAsJsonArray("blockEntityTypes"));
            this.deserializeEntries(res.entityTypes, object.getAsJsonArray("entityTypes"));
            res.addBlacklistTags();
            res.configVersion = object.get("configVersion").getAsInt();
            res.pluginHash = (int[])context.deserialize(object.get("pluginHash"), int[].class);
            return res;
        }

        private void deserializeEntries(LinkedHashSet<String> set, JsonArray array) {
            for (JsonElement entry : array) {
                set.add(entry.getAsString());
            }
        }
    }
}

