/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network.play.c2s;

import lol.bai.badpackets.api.PacketSender;
import lol.bai.badpackets.api.play.PlayPackets;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataReader;
import mcp.mobius.waila.access.DataWriter;
import mcp.mobius.waila.access.ServerAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.network.Packet;
import mcp.mobius.waila.registry.Registrar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BlockDataRequestPlayC2SPacket
implements Packet {
    public static final CustomPacketPayload.Type<Payload> TYPE = new CustomPacketPayload.Type(Waila.id("block"));
    public static final StreamCodec<FriendlyByteBuf, Payload> CODEC = StreamCodec.ofMember((p, buf) -> buf.writeBlockHitResult(p.hitResult), buf -> new Payload(buf.readBlockHitResult()));

    @Override
    public void common() {
        PlayPackets.registerServerChannel(TYPE, CODEC);
        PlayPackets.registerServerReceiver(TYPE, (context, payload) -> {
            BlockPos pos;
            ServerPlayer player = context.player();
            BlockHitResult hitResult = payload.hitResult;
            Registrar registrar = Registrar.get();
            Level world = player.level();
            if (!world.hasChunkAt(pos = hitResult.getBlockPos())) {
                return;
            }
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity == null) {
                return;
            }
            BlockState state = world.getBlockState(pos);
            CompoundTag raw = DataWriter.SERVER.reset();
            IServerAccessor accessor = ServerAccessor.INSTANCE.set(world, player, (HitResult)hitResult, blockEntity);
            for (IInstanceRegistry.Entry<IDataProvider<BlockEntity>> provider : registrar.blockData.get(blockEntity)) {
                DataWriter.SERVER.tryAppend((Player)player, provider.instance(), accessor, PluginConfig.SERVER, IDataProvider::appendData);
            }
            for (IInstanceRegistry.Entry<IDataProvider<BlockEntity>> provider : registrar.blockData.get(state.getBlock())) {
                DataWriter.SERVER.tryAppend((Player)player, provider.instance(), accessor, PluginConfig.SERVER, IDataProvider::appendData);
            }
            raw.putInt("x", pos.getX());
            raw.putInt("y", pos.getY());
            raw.putInt("z", pos.getZ());
            raw.putString("id", BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)blockEntity.getType()).toString());
            raw.putLong("WailaTime", System.currentTimeMillis());
            DataWriter.SERVER.send((PacketSender)context, (Player)player);
            DataReader.SERVER.reset(null);
        });
    }

    public record Payload(BlockHitResult hitResult) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

