/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.config.input.KeyBind;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.hud.theme.ThemeDefinition;
import mcp.mobius.waila.gui.screen.TabbedConfigScreen;
import mcp.mobius.waila.gui.screen.ThemeEditorScreen;
import mcp.mobius.waila.gui.screen.YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen;
import mcp.mobius.waila.gui.widget.ButtonEntry;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.BooleanValue;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.gui.widget.value.CycleValue;
import mcp.mobius.waila.gui.widget.value.EnumValue;
import mcp.mobius.waila.gui.widget.value.InputValue;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2i;

public class WailaConfigScreen
extends TabbedConfigScreen {
    public static final Component TITLE = Component.translatable((String)"gui.waila.waila_settings", (Object[])new Object[]{"WTHIT"});
    private static final Component PREVIEW_PROMPT = Component.translatable((String)"config.waila.preview_prompt");
    private final WailaConfig defaultConfig = new WailaConfig();
    private final TooltipRenderer.State previewState = new PreviewTooltipRendererState();
    @Nullable
    private ThemeDefinition<?> theme;
    private boolean f1held = false;
    private InputValue<String> modNameFormatVal;
    private InputValue<String> blockNameFormatVal;
    private InputValue<Integer> fpsVal;
    private ButtonEntry placementButton;
    private EnumValue<IWailaConfig.Overlay.Position.Align.X> xAnchorValue;
    private EnumValue<IWailaConfig.Overlay.Position.Align.Y> yAnchorValue;
    private EnumValue<IWailaConfig.Overlay.Position.Align.X> xAlignValue;
    private EnumValue<IWailaConfig.Overlay.Position.Align.Y> yAlignValue;
    private InputValue<Integer> xPosValue;
    private InputValue<Integer> yPosValue;
    private InputValue<Float> scaleValue;
    private InputValue<Integer> backgroundAlphaVal;
    private ThemeValue themeIdVal;
    @Nullable
    private KeyBindValue selectedKeyBind;

    public WailaConfigScreen(Screen parent) {
        super(parent, CommonComponents.EMPTY, WailaClient.CONFIG::save, WailaClient.CONFIG::invalidate);
    }

    private static WailaConfig get() {
        return WailaClient.CONFIG.get();
    }

    public Rectangle buildPreview(TooltipRenderer.State state) {
        TooltipRenderer.beginBuild(state);
        TooltipRenderer.setIcon(new ItemComponent((ItemLike)Blocks.GRASS_BLOCK));
        TooltipRenderer.add(new Line(null).with((Component)Component.literal((String)DisplayUtil.tryFormat((String)this.blockNameFormatVal.getValue(), Blocks.GRASS_BLOCK.getName().getString()))));
        TooltipRenderer.add(new Line(null).with((Component)Component.literal((String)"never gonna give you up").withStyle(ChatFormatting.OBFUSCATED)));
        TooltipRenderer.add(new Line(null).with((Component)Component.literal((String)DisplayUtil.tryFormat((String)this.modNameFormatVal.getValue(), IModInfo.get(Blocks.GRASS_BLOCK).getName()))));
        return TooltipRenderer.endBuild();
    }

    public void addTheme(ThemeDefinition<?> theme) {
        WailaConfigScreen.get().getOverlay().getColor().getCustomThemes().put(theme.id, theme);
        ThemeDefinition.resetAll();
        String id = theme.id.toString();
        this.themeIdVal.addValue(id);
        this.themeIdVal.setValue(id);
        this.theme = theme;
    }

    public void removeTheme(ResourceLocation id) {
        WailaConfigScreen.get().getOverlay().getColor().getCustomThemes().remove(id);
        ThemeDefinition.resetAll();
        this.themeIdVal.removeValue(id.toString());
        this.theme = null;
    }

    private ThemeDefinition<?> getTheme() {
        if (this.theme == null) {
            this.theme = ThemeDefinition.getAll().get(ResourceLocation.parse((String)((String)this.themeIdVal.getValue())));
        }
        return this.theme;
    }

    @Override
    public void render(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        if (InputConstants.isKeyDown((Window)this.minecraft.getWindow(), (int)290)) {
            if (!this.f1held) {
                this.f1held = true;
                this.buildPreview(this.previewState);
            }
            TooltipRenderer.render(ctx, this.minecraft.getDeltaTracker());
        } else {
            TooltipRenderer.resetState();
            this.f1held = false;
            this.theme = null;
            super.render(ctx, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public ConfigListWidget getOptions() {
        ConfigListWidget options = new ConfigListWidget(this, this.minecraft, this.width, this.height, 24, this.height - 32, 26, WailaClient.CONFIG::save);
        options.headerSeparator = false;
        options.with(new CategoryEntry("config.waila.general").with(new BooleanValue("config.waila.vanilla_options", WailaConfigScreen.get().getGeneral().vanillaOptions(), this.defaultConfig.getGeneral().vanillaOptions(), val -> WailaConfigScreen.get().getGeneral().setVanillaOptions((boolean)val))).with(new BooleanValue("config.waila.display_tooltip", WailaConfigScreen.get().getGeneral().isDisplayTooltip(), this.defaultConfig.getGeneral().isDisplayTooltip(), val -> WailaConfigScreen.get().getGeneral().setDisplayTooltip((boolean)val))).with(new BooleanValue("config.waila.sneaky_details", WailaConfigScreen.get().getGeneral().isShiftForDetails(), this.defaultConfig.getGeneral().isShiftForDetails(), val -> WailaConfigScreen.get().getGeneral().setShiftForDetails((boolean)val))).with(new BooleanValue("config.waila.hide_sneak_text", WailaConfigScreen.get().getGeneral().isHideShiftText(), this.defaultConfig.getGeneral().isHideShiftText(), val -> WailaConfigScreen.get().getGeneral().setHideShiftText((boolean)val))).with(new EnumValue("config.waila.display_mode", (Enum[])IWailaConfig.General.DisplayMode.values(), (Enum)WailaConfigScreen.get().getGeneral().getDisplayMode(), (Enum)this.defaultConfig.getGeneral().getDisplayMode(), val -> WailaConfigScreen.get().getGeneral().setDisplayMode((IWailaConfig.General.DisplayMode)((Object)val)))).with(new BooleanValue("config.waila.hide_from_players", WailaConfigScreen.get().getGeneral().isHideFromPlayerList(), this.defaultConfig.getGeneral().isHideFromPlayerList(), val -> WailaConfigScreen.get().getGeneral().setHideFromPlayerList((boolean)val))).with(new BooleanValue("config.waila.hide_from_debug", WailaConfigScreen.get().getGeneral().isHideFromDebug(), this.defaultConfig.getGeneral().isHideFromDebug(), val -> WailaConfigScreen.get().getGeneral().setHideFromDebug((boolean)val))).with(new BooleanValue("config.waila.tts", WailaConfigScreen.get().getGeneral().isEnableTextToSpeech(), this.defaultConfig.getGeneral().isEnableTextToSpeech(), val -> WailaConfigScreen.get().getGeneral().setEnableTextToSpeech((boolean)val))).with(new InputValue<Integer>("config.waila.rate_limit", WailaConfigScreen.get().getGeneral().getRateLimit(), this.defaultConfig.getGeneral().getRateLimit(), val -> WailaConfigScreen.get().getGeneral().setRateLimit(Math.max(val, 250)), InputValue.POSITIVE_INTEGER)).with(new ButtonEntry("config.waila.blacklist", "config.waila.blacklist_open", 100, 20, w -> Util.getPlatform().openFile(Waila.BLACKLIST_CONFIG.getPath().toFile()))));
        this.fpsVal = (InputValue)((Object)Util.make(new InputValue<Integer>("config.waila.overlay_fps", WailaConfigScreen.get().getOverlay().getFps(), this.defaultConfig.getOverlay().getFps(), val -> WailaConfigScreen.get().getOverlay().setFps((int)val), InputValue.POSITIVE_INTEGER), it -> it.disable("config.waila.overlay_fps.disabled_reason")));
        this.placementButton = new ButtonEntry("config.waila.overlay_placement", 100, 20, w -> this.minecraft.setScreen((Screen)new PlacementScreen()));
        this.xAnchorValue = new EnumValue("config.waila.overlay_anchor", (Enum[])IWailaConfig.Overlay.Position.Align.X.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAnchor().getX(), (Enum)this.defaultConfig.getOverlay().getPosition().getAnchor().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAnchor().setX((IWailaConfig.Overlay.Position.Align.X)((Object)val)));
        this.yAnchorValue = new EnumValue("config.waila.overlay_anchor", (Enum[])IWailaConfig.Overlay.Position.Align.Y.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAnchor().getY(), (Enum)this.defaultConfig.getOverlay().getPosition().getAnchor().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAnchor().setY((IWailaConfig.Overlay.Position.Align.Y)((Object)val)));
        this.xAlignValue = new EnumValue("config.waila.overlay_anchor", (Enum[])IWailaConfig.Overlay.Position.Align.X.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAlign().getX(), (Enum)this.defaultConfig.getOverlay().getPosition().getAlign().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAlign().setX((IWailaConfig.Overlay.Position.Align.X)((Object)val)));
        this.yAlignValue = new EnumValue("config.waila.overlay_anchor", (Enum[])IWailaConfig.Overlay.Position.Align.Y.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAlign().getY(), (Enum)this.defaultConfig.getOverlay().getPosition().getAlign().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAlign().setY((IWailaConfig.Overlay.Position.Align.Y)((Object)val)));
        this.xPosValue = new InputValue<Integer>("config.waila.overlay_offset", WailaConfigScreen.get().getOverlay().getPosition().getX(), this.defaultConfig.getOverlay().getPosition().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().setX((int)val), InputValue.INTEGER);
        this.yPosValue = new InputValue<Integer>("config.waila.overlay_offset", WailaConfigScreen.get().getOverlay().getPosition().getY(), this.defaultConfig.getOverlay().getPosition().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().setY((int)val), InputValue.INTEGER);
        this.scaleValue = new InputValue<Float>("config.waila.overlay_scale", Float.valueOf(WailaConfigScreen.get().getOverlay().getScale()), Float.valueOf(this.defaultConfig.getOverlay().getScale()), val -> WailaConfigScreen.get().getOverlay().setScale(Math.max(val.floatValue(), 0.0f)), InputValue.POSITIVE_DECIMAL);
        this.backgroundAlphaVal = new InputValue<Integer>("config.waila.overlay_background_alpha", WailaConfigScreen.get().getOverlay().getColor().getBackgroundAlpha(), this.defaultConfig.getOverlay().getColor().getBackgroundAlpha(), val -> WailaConfigScreen.get().getOverlay().getColor().setBackgroundAlpha(Mth.clamp((int)val, (int)0, (int)255)), InputValue.POSITIVE_INTEGER);
        this.themeIdVal = new ThemeValue();
        options.with(new CategoryEntry("config.waila.overlay").with(this.fpsVal).with(this.placementButton).withHidden(this.xAnchorValue).withHidden(this.yAnchorValue).withHidden(this.xAlignValue).withHidden(this.yAlignValue).withHidden(this.xPosValue).withHidden(this.yPosValue).with(new BooleanValue("config.waila.boss_bars_overlap", WailaConfigScreen.get().getOverlay().getPosition().isBossBarsOverlap(), this.defaultConfig.getOverlay().getPosition().isBossBarsOverlap(), val -> WailaConfigScreen.get().getOverlay().getPosition().setBossBarsOverlap((boolean)val))).withHidden(this.scaleValue).with(this.backgroundAlphaVal).with(this.themeIdVal));
        this.modNameFormatVal = new InputValue<String>("config.waila.format_mod_name", WailaConfigScreen.get().getFormatter().getModName(), this.defaultConfig.getFormatter().getModName(), val -> WailaConfigScreen.get().getFormatter().setModName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getModName() : val), InputValue.ANY);
        this.blockNameFormatVal = new InputValue<String>("config.waila.format_block_name", WailaConfigScreen.get().getFormatter().getBlockName(), this.defaultConfig.getFormatter().getBlockName(), val -> WailaConfigScreen.get().getFormatter().setBlockName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getBlockName() : val), InputValue.ANY);
        options.with(new CategoryEntry("config.waila.formatting").with(this.modNameFormatVal).with(this.blockNameFormatVal).with(new InputValue<String>("config.waila.format_fluid_name", WailaConfigScreen.get().getFormatter().getFluidName(), this.defaultConfig.getFormatter().getFluidName(), val -> WailaConfigScreen.get().getFormatter().setFluidName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getFluidName() : val), InputValue.ANY)).with(new InputValue<String>("config.waila.format_entity_name", WailaConfigScreen.get().getFormatter().getEntityName(), this.defaultConfig.getFormatter().getEntityName(), val -> WailaConfigScreen.get().getFormatter().setEntityName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getEntityName() : val), InputValue.ANY)).with(new InputValue<String>("config.waila.format_registry_name", WailaConfigScreen.get().getFormatter().getRegistryName(), this.defaultConfig.getFormatter().getRegistryName(), val -> WailaConfigScreen.get().getFormatter().setRegistryName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getRegistryName() : val), InputValue.ANY)));
        options.with(new CategoryEntry("config.waila.keybinds").with(new KeyBindValue("key.waila.config", WailaConfigScreen.get().getKeyBinds().getOpenConfig(), this.defaultConfig.getKeyBinds().getOpenConfig(), val -> WailaConfigScreen.get().getKeyBinds().setOpenConfig((KeyBind)val))).with(new KeyBindValue("key.waila.show_overlay", WailaConfigScreen.get().getKeyBinds().getShowOverlay(), this.defaultConfig.getKeyBinds().getShowOverlay(), val -> WailaConfigScreen.get().getKeyBinds().setShowOverlay((KeyBind)val))).with(new KeyBindValue("key.waila.toggle_liquid", WailaConfigScreen.get().getKeyBinds().getToggleLiquid(), this.defaultConfig.getKeyBinds().getToggleLiquid(), val -> WailaConfigScreen.get().getKeyBinds().setToggleLiquid((KeyBind)val))).with(new KeyBindValue("key.waila.show_recipe_input", WailaConfigScreen.get().getKeyBinds().getShowRecipeInput(), this.defaultConfig.getKeyBinds().getShowRecipeInput(), val -> WailaConfigScreen.get().getKeyBinds().setShowRecipeInput((KeyBind)val))).with(new KeyBindValue("key.waila.show_recipe_output", WailaConfigScreen.get().getKeyBinds().getShowRecipeOutput(), this.defaultConfig.getKeyBinds().getShowRecipeOutput(), val -> WailaConfigScreen.get().getKeyBinds().setShowRecipeOutput((KeyBind)val))));
        return options;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubled) {
        if (this.selectedKeyBind != null) {
            this.selectedKeyBind.setValue(KeyBind.of(InputConstants.Type.MOUSE.getOrCreate(event.button())));
            this.selectedKeyBind = null;
            return true;
        }
        return this.f1held || super.mouseClicked(event, doubled);
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        if (this.selectedKeyBind != null) {
            if (event.key() == 256) {
                this.selectedKeyBind.setValue(KeyBind.UNKNOWN);
            } else {
                this.selectedKeyBind.setValue(KeyBind.of(InputConstants.getKey((KeyEvent)event)));
            }
            this.selectedKeyBind = null;
            return true;
        }
        return super.keyPressed(event);
    }

    private class PreviewTooltipRendererState
    implements TooltipRenderer.State {
        private PreviewTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return true;
        }

        @Override
        public boolean fireEvent() {
            return false;
        }

        @Override
        public int getFps() {
            return (Integer)WailaConfigScreen.this.fpsVal.getValue();
        }

        @Override
        public int getBackgroundAlpha() {
            return (Integer)WailaConfigScreen.this.backgroundAlphaVal.getValue();
        }

        @Override
        public float getScale() {
            return ((Float)WailaConfigScreen.this.scaleValue.getValue()).floatValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return (IWailaConfig.Overlay.Position.Align.X)((Object)WailaConfigScreen.this.xAnchorValue.getValue());
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return (IWailaConfig.Overlay.Position.Align.Y)((Object)WailaConfigScreen.this.yAnchorValue.getValue());
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return (IWailaConfig.Overlay.Position.Align.X)((Object)WailaConfigScreen.this.xAlignValue.getValue());
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return (IWailaConfig.Overlay.Position.Align.Y)((Object)WailaConfigScreen.this.yAlignValue.getValue());
        }

        @Override
        public int getX() {
            return (Integer)WailaConfigScreen.this.xPosValue.getValue();
        }

        @Override
        public int getY() {
            return (Integer)WailaConfigScreen.this.yPosValue.getValue();
        }

        @Override
        public boolean bossBarsOverlap() {
            return false;
        }

        @Override
        public ITheme getTheme() {
            return WailaConfigScreen.this.getTheme().getInitializedInstance();
        }

        @Override
        public boolean enableTextToSpeech() {
            return false;
        }
    }

    private class ThemeValue
    extends CycleValue {
        private final Button editButton;
        private final Button newButton;

        public ThemeValue() {
            super("config.waila.overlay_theme", (String[])ThemeDefinition.getAll().values().stream().map(t -> t.id.toString()).sorted(String::compareToIgnoreCase).toArray(String[]::new), WailaConfigScreen.get().getOverlay().getColor().getActiveTheme().toString(), val -> WailaConfigScreen.get().getOverlay().getColor().applyTheme(ResourceLocation.parse((String)val)), false);
            this.editButton = DisplayUtil.createButton(0, 0, 40, 20, (Component)Component.translatable((String)"config.waila.edit"), button -> this.client.setScreen((Screen)new ThemeEditorScreen(WailaConfigScreen.this, WailaConfigScreen.this.getTheme(), true)));
            this.newButton = DisplayUtil.createButton(0, 0, 40, 20, (Component)Component.translatable((String)"config.waila.new"), button -> this.client.setScreen((Screen)new ThemeEditorScreen(WailaConfigScreen.this, WailaConfigScreen.this.getTheme(), false)));
            this.reloadEditButton();
        }

        private void reloadEditButton() {
            this.editButton.active = !ThemeDefinition.getAll().get((Object)ResourceLocation.parse((String)((String)this.getValue()))).builtin;
        }

        @Override
        protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
            super.gatherChildren(children);
            children.add((Object)this.editButton);
            children.add((Object)this.newButton);
        }

        @Override
        public void setValue(String value) {
            super.setValue(value);
            this.reloadEditButton();
        }

        @Override
        protected void drawValue(GuiGraphics ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.newButton.setX(x + width - this.newButton.getWidth());
            this.newButton.setY(y + (height - this.newButton.getHeight()) / 2);
            this.editButton.setX(this.newButton.getX() - this.newButton.getWidth() - 2);
            this.editButton.setY(this.newButton.getY());
            this.editButton.render(ctx, mouseX, mouseY, partialTicks);
            this.newButton.render(ctx, mouseX, mouseY, partialTicks);
            super.drawValue(ctx, width - 84, height, x, y, mouseX, mouseY, selected, partialTicks);
        }
    }

    public class KeyBindValue
    extends ConfigValue<KeyBind, KeyBindValue> {
        private final Button button;

        public KeyBindValue(String translationKey, KeyBind value, KeyBind defaultValue, Consumer<KeyBind> save) {
            super(translationKey, value, defaultValue, save);
            this.button = DisplayUtil.createButton(0, 0, 100, 20, (Component)Component.empty(), w -> {
                WailaConfigScreen.this.selectedKeyBind = this;
            });
        }

        @Override
        public GuiEventListener getListener() {
            return this.button;
        }

        @Override
        protected void drawValue(GuiGraphics ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (WailaConfigScreen.this.selectedKeyBind == this) {
                this.button.setMessage((Component)Component.literal((String)("> " + ((KeyBind)this.getValue()).key().getDisplayName().getString() + " <")).withStyle(ChatFormatting.YELLOW));
            } else {
                this.button.setMessage(((KeyBind)this.getValue()).key().getDisplayName());
            }
            this.button.setX(x + width - this.button.getWidth());
            this.button.setY(y + (height - this.button.getHeight()) / 2);
            this.button.render(ctx, mouseX, mouseY, partialTicks);
        }
    }

    private class PlacementScreen
    extends YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen {
        static final Object WATCHER_OFFSET = new Object();
        static final Object WATCHER_UPDATE = new Object();
        final MutableObject<Component> textAlign;
        final MutableObject<Component> textAnchor;
        final MutableObject<Component> textOffset;
        final MutableObject<Component> textScale;
        final Rectangle rect;
        float oldScale;
        boolean drag;
        Vector2i dragPos;
        Vector2d dragStart;
        Vector2d dragNow;
        Button xAlign;
        Button yAlign;
        Button xAnchor;
        Button yAnchor;
        InputValue.WatchedTextfield xPos;
        InputValue.WatchedTextfield yPos;
        InputValue.WatchedTextfield scale;
        Button done;
        int x;
        int y;
        int maxTextWidth;

        public PlacementScreen() {
            super((Component)Component.translatable((String)"config.waila.overlay"));
            this.textAlign = new MutableObject((Object)Component.translatable((String)"config.waila.overlay_align"));
            this.textAnchor = new MutableObject((Object)Component.translatable((String)"config.waila.overlay_anchor"));
            this.textOffset = new MutableObject((Object)Component.translatable((String)"config.waila.overlay_offset"));
            this.textScale = new MutableObject((Object)Component.translatable((String)"config.waila.overlay_scale"));
            this.rect = new Rectangle();
            this.dragPos = new Vector2i();
            this.dragStart = new Vector2d();
            this.dragNow = new Vector2d();
        }

        private void resetOffset(ConfigValue<?, ?> value) {
            if (!value.isChanged()) {
                return;
            }
            WailaConfigScreen.this.xPosValue.setValue(0);
            WailaConfigScreen.this.yPosValue.setValue(0);
        }

        private void addUpdateWatcher(MutableObject<Component> text, ConfigValue<?, ?> ... cvs) {
            for (ConfigValue<?, ?> cv : cvs) {
                cv.addWatcher(WATCHER_UPDATE, v -> {
                    if (!Arrays.stream(cvs).allMatch(ConfigValue::isValueValid)) {
                        text.setValue((Object)((Component)text.getValue()).plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED}));
                    } else if (Arrays.stream(cvs).anyMatch(ConfigValue::isChanged)) {
                        text.setValue((Object)((Component)text.getValue()).plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW}));
                    } else {
                        text.setValue((Object)((Component)text.getValue()).plainCopy());
                    }
                });
            }
        }

        @Override
        protected void init() {
            super.init();
            this.xAnchor = WailaConfigScreen.this.xAnchorValue.getListener();
            this.addRenderableWidget((GuiEventListener)this.xAnchor);
            this.yAnchor = WailaConfigScreen.this.yAnchorValue.getListener();
            this.addRenderableWidget((GuiEventListener)this.yAnchor);
            this.addUpdateWatcher(this.textAnchor, WailaConfigScreen.this.xAnchorValue, WailaConfigScreen.this.yAnchorValue);
            WailaConfigScreen.this.xAnchorValue.addWatcher(WATCHER_OFFSET, this::resetOffset);
            WailaConfigScreen.this.yAnchorValue.addWatcher(WATCHER_OFFSET, this::resetOffset);
            this.xAnchor.setWidth(50);
            this.yAnchor.setWidth(50);
            this.xAlign = WailaConfigScreen.this.xAlignValue.getListener();
            this.addRenderableWidget((GuiEventListener)this.xAlign);
            this.yAlign = WailaConfigScreen.this.yAlignValue.getListener();
            this.addRenderableWidget((GuiEventListener)this.yAlign);
            this.addUpdateWatcher(this.textAlign, WailaConfigScreen.this.xAlignValue, WailaConfigScreen.this.yAlignValue);
            this.xAlign.setWidth(50);
            this.yAlign.setWidth(50);
            this.xPos = WailaConfigScreen.this.xPosValue.getListener();
            this.addRenderableWidget((GuiEventListener)this.xPos);
            this.yPos = WailaConfigScreen.this.yPosValue.getListener();
            this.addRenderableWidget((GuiEventListener)this.yPos);
            this.addUpdateWatcher(this.textOffset, WailaConfigScreen.this.xPosValue, WailaConfigScreen.this.yPosValue);
            this.yPos.grow = false;
            this.xPos.grow = false;
            this.xPos.setWidth(50);
            this.yPos.setWidth(50);
            this.scale = WailaConfigScreen.this.scaleValue.getListener();
            this.addRenderableWidget((GuiEventListener)this.scale);
            this.addUpdateWatcher(this.textScale, WailaConfigScreen.this.scaleValue);
            this.oldScale = ((Float)WailaConfigScreen.this.scaleValue.getValue()).floatValue();
            this.scale.grow = false;
            this.scale.setWidth(102);
            WailaConfigScreen.this.scaleValue.addWatcher(WATCHER_OFFSET, v -> {
                if (v.isChanged()) {
                    this.resetOffset((ConfigValue<?, ?>)((Object)v));
                }
                this.oldScale = ((Float)v.getValue()).floatValue();
            });
            this.done = DisplayUtil.createButton(0, 0, 102, 20, CommonComponents.GUI_DONE, b -> {
                List<InputValue<Float>> list = List.of(WailaConfigScreen.this.xAnchorValue, WailaConfigScreen.this.yAnchorValue, WailaConfigScreen.this.xAlignValue, WailaConfigScreen.this.yAlignValue, WailaConfigScreen.this.xPosValue, WailaConfigScreen.this.yPosValue, WailaConfigScreen.this.scaleValue);
                if (!list.stream().allMatch(ConfigValue::isValueValid)) {
                    ConfigListWidget.showErrorToast(this.minecraft);
                    return;
                }
                MutableComponent message = Component.translatable((String)"config.waila.overlay_placement");
                boolean changed = list.stream().anyMatch(ConfigValue::isChanged);
                if (changed) {
                    message.withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
                }
                WailaConfigScreen.this.placementButton.setTitle((Component)message);
                this.minecraft.setScreen((Screen)WailaConfigScreen.this);
            });
            this.addRenderableWidget((GuiEventListener)this.done);
            this.tick();
        }

        public void tick() {
            this.maxTextWidth = this.minecraft.font.width((FormattedText)this.textAlign.getValue());
            this.maxTextWidth = Math.max(this.maxTextWidth, this.minecraft.font.width((FormattedText)this.textAnchor.getValue()));
            this.maxTextWidth = Math.max(this.maxTextWidth, this.minecraft.font.width((FormattedText)this.textOffset.getValue()));
            this.maxTextWidth = Math.max(this.maxTextWidth, this.minecraft.font.width((FormattedText)this.textScale.getValue()));
            Rectangle r = WailaConfigScreen.this.buildPreview(WailaConfigScreen.this.previewState);
            float s = ((Float)WailaConfigScreen.this.scaleValue.getValue()).floatValue();
            this.rect.setBounds((int)((float)r.x * s), (int)((float)r.y * s), (int)((float)r.width * s), (int)((float)r.height * s));
            int optWidth = this.maxTextWidth + 10 + 50 + 2 + 50;
            int optHeight = 110;
            this.x = this.width - optWidth - 10;
            this.y = this.height - optHeight - 10;
            if (this.rect.intersects(this.x, this.y, optWidth, optHeight)) {
                this.x = 10;
                this.y = 10;
            }
            int i = 0;
            int optX = this.x + this.maxTextWidth + 10;
            this.xAnchor.setPosition(optX, this.y + 22 * i++);
            this.yAnchor.setPosition(this.xAnchor.getX() + this.xAnchor.getWidth() + 2, this.xAnchor.getY());
            this.xAlign.setPosition(optX, this.y + 22 * i++);
            this.yAlign.setPosition(this.xAlign.getX() + this.xAlign.getWidth() + 2, this.xAlign.getY());
            this.xPos.setPosition(optX, this.y + 22 * i++);
            this.yPos.setPosition(this.xPos.getX() + this.xPos.getWidth() + 2, this.xPos.getY());
            this.scale.setPosition(optX, this.y + 22 * i++);
            this.done.setPosition(optX, this.y + 22 * i++);
        }

        public void render(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
            super.render(ctx, mouseX, mouseY, delta);
            if (this.rect.contains((double)mouseX, (double)mouseY)) {
                ctx.requestCursor(CursorTypes.RESIZE_ALL);
            }
            int i = 0;
            Objects.requireNonNull(this.minecraft.font);
            int y = this.y + 9 / 2;
            ctx.drawString(this.minecraft.font, (Component)this.textAnchor.getValue(), this.x, y + 22 * i++, -1);
            ctx.drawString(this.minecraft.font, (Component)this.textAlign.getValue(), this.x, y + 22 * i++, -1);
            ctx.drawString(this.minecraft.font, (Component)this.textOffset.getValue(), this.x, y + 22 * i++, -1);
            ctx.drawString(this.minecraft.font, (Component)this.textScale.getValue(), this.x, y + 22 * i++, -1);
            TooltipRenderer.render(ctx, this.minecraft.getDeltaTracker());
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubled) {
            if (this.rect.contains(event.x(), event.y())) {
                this.drag = true;
                this.dragPos.set(((Integer)WailaConfigScreen.this.xPosValue.getValue()).intValue(), ((Integer)WailaConfigScreen.this.yPosValue.getValue()).intValue());
                this.dragStart.x = this.dragNow.x = event.x();
                this.dragStart.y = this.dragNow.y = event.y();
            }
            return super.mouseClicked(event, doubled);
        }

        public boolean mouseDragged(MouseButtonEvent event, double offsetX, double offsetY) {
            if (this.drag) {
                float scale = ((Float)WailaConfigScreen.this.scaleValue.getValue()).floatValue();
                WailaConfigScreen.this.xPosValue.setValue((int)((double)this.dragPos.x + (this.dragNow.x - this.dragStart.x) / (double)scale));
                WailaConfigScreen.this.yPosValue.setValue((int)((double)this.dragPos.y + (this.dragNow.y - this.dragStart.y) / (double)scale));
                this.dragNow.x = event.x();
                this.dragNow.y = event.y();
                return true;
            }
            return super.mouseDragged(event, offsetX, offsetY);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            this.drag = false;
            return super.mouseReleased(event);
        }

        public boolean keyPressed(KeyEvent event) {
            int offset = event.hasControlDown() ? 10 : 1;
            switch (event.key()) {
                case 265: {
                    WailaConfigScreen.this.yPosValue.setValue((Integer)WailaConfigScreen.this.yPosValue.getValue() - offset);
                    break;
                }
                case 264: {
                    WailaConfigScreen.this.yPosValue.setValue((Integer)WailaConfigScreen.this.yPosValue.getValue() + offset);
                    break;
                }
                case 263: {
                    WailaConfigScreen.this.xPosValue.setValue((Integer)WailaConfigScreen.this.xPosValue.getValue() - offset);
                    break;
                }
                case 262: {
                    WailaConfigScreen.this.xPosValue.setValue((Integer)WailaConfigScreen.this.xPosValue.getValue() + offset);
                    break;
                }
                default: {
                    return super.keyPressed(event);
                }
            }
            return true;
        }

        public boolean shouldCloseOnEsc() {
            return false;
        }
    }
}

