/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.__internal__.ApiSide;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

@ApiSide.ClientOnly
public class BarComponent
implements ITooltipComponent {
    static final int WIDTH = 100;
    static final int HEIGHT = 11;
    private static final float U0 = 0.0859375f;
    static final float U1 = 0.4765625f;
    static final float V0_BG = 0.0f;
    static final float V1_BG = 0.04296875f;
    private static final float V0_FG = 0.04296875f;
    private static final float V1_FG = 0.0859375f;
    private static final float UV_W = 0.390625f;
    private final float ratio;
    private final int color;
    private final Component text;

    public BarComponent(float ratio, int color) {
        this(ratio, color, CommonComponents.EMPTY);
    }

    public BarComponent(float ratio, int color, String text) {
        this(ratio, color, (Component)Component.literal((String)text));
    }

    public BarComponent(float ratio, int color, Component text) {
        this.ratio = ratio;
        this.color = color;
        this.text = text;
    }

    @Override
    public int getWidth() {
        return Math.max(Minecraft.getInstance().font.width((FormattedText)this.text), 100);
    }

    @Override
    public int getHeight() {
        return 11;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        BarComponent.renderBar(ctx.pose(), x, y, 100.0f, 0.0f, 0.4765625f, 0.04296875f, this.color);
        BarComponent.renderBar(ctx.pose(), x, y, 100.0f * this.ratio, 0.04296875f, 0.0859375f + 0.390625f * this.ratio, 0.0859375f, this.color);
        BarComponent.renderText(ctx, this.text, x, y);
    }

    static void renderBar(PoseStack matrices, int x, int y, float w, float v0, float u1, float v1, int tint) {
        matrices.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WailaConstants.COMPONENT_TEXTURE);
        int a = WailaHelper.getAlpha(tint);
        int r = WailaHelper.getRed(tint);
        int g = WailaHelper.getGreen(tint);
        int b = WailaHelper.getBlue(tint);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(matrices.last().pose(), (float)x, (float)(y + 11), 0.0f).setUv(0.0859375f, v1).setColor(r, g, b, a);
        buffer.addVertex(matrices.last().pose(), (float)x + w, (float)(y + 11), 0.0f).setUv(u1, v1).setColor(r, g, b, a);
        buffer.addVertex(matrices.last().pose(), (float)x + w, (float)y, 0.0f).setUv(u1, v0).setColor(r, g, b, a);
        buffer.addVertex(matrices.last().pose(), (float)x, (float)y, 0.0f).setUv(0.0859375f, v0).setColor(r, g, b, a);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
        matrices.popPose();
    }

    static void renderText(GuiGraphics ctx, Component text, int x, int y) {
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width((FormattedText)text);
        float textX = (float)x + Math.max((float)(100 - textWidth) / 2.0f, 0.0f);
        float textY = y + 2;
        font.drawInBatch8xOutline(text.getVisualOrderText(), textX, textY, 0xAAAAAA, 0x292929, ctx.pose().last().pose(), (MultiBufferSource)ctx.bufferSource(), 0xF000F0);
        ctx.bufferSource().endBatch();
    }
}

