/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.theme;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeAccessor;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IntFormat;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Range;
import org.joml.Matrix4f;

public class NinePatchTheme
implements ITheme {
    public static final IThemeType<NinePatchTheme> TYPE = IThemeType.of(NinePatchTheme.class).property("texture", "waila:textures/ninepatch_example.png").property("useResourcePack", true).property("textColor", IntFormat.RGB_HEX, 0xA0A0A0).property("textureWidth", 16).property("textureHeight", 16).property("regionTop", 3).property("regionBottom", 3).property("regionLeft", 3).property("regionRight", 3).property("mode", Mode.STRETCH).build();
    private String texture;
    private boolean useResourcePack;
    private int textColor;
    private int textureWidth;
    private int textureHeight;
    private int regionTop;
    private int regionBottom;
    private int regionLeft;
    private int regionRight;
    private Mode mode;
    private ResourceLocation textureId;
    private float uCenter;
    private float uRight;
    private float vMiddle;
    private float vBottom;

    @Override
    public void processProperties(IThemeAccessor accessor) {
        this.textColor = Mth.clamp((int)this.textColor, (int)0, (int)0xFFFFFF);
        this.regionTop = Mth.clamp((int)this.regionTop, (int)0, (int)this.textureHeight);
        this.regionBottom = Mth.clamp((int)this.regionBottom, (int)0, (int)(this.textureHeight - this.regionTop));
        this.regionLeft = Mth.clamp((int)this.regionLeft, (int)0, (int)this.textureWidth);
        this.regionRight = Mth.clamp((int)this.regionRight, (int)0, (int)(this.textureWidth - this.regionLeft));
        if (this.useResourcePack) {
            this.textureId = ResourceLocation.parse((String)this.texture);
        } else {
            try {
                NativeImage image = NativeImage.read((InputStream)Files.newInputStream(accessor.getPath(this.texture), new OpenOption[0]));
                this.textureId = Minecraft.getInstance().getTextureManager().register("waila_9p", new DynamicTexture(image));
            }
            catch (Exception e) {
                this.textureId = TextureManager.INTENTIONAL_MISSING_TEXTURE;
            }
        }
        float tw = this.textureWidth;
        float th = this.textureHeight;
        this.uCenter = (float)this.regionLeft / tw;
        this.uRight = (tw - (float)this.regionRight) / tw;
        this.vMiddle = (float)this.regionTop / th;
        this.vBottom = (th - (float)this.regionBottom) / th;
    }

    @Override
    public int getDefaultTextColor() {
        return this.textColor;
    }

    @Override
    public void setPadding(ITheme.Padding padding) {
        padding.set(this.regionTop, this.regionRight, this.regionBottom, this.regionLeft);
    }

    @Override
    public void renderTooltipBackground(GuiGraphics ctx, int x, int y, int width, int height, @Range(from=0L, to=255L) int alpha, DeltaTracker delta) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.textureId);
        BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f matrix = ctx.pose().last().pose();
        this.patch(buf, matrix, x, y, this.regionLeft, this.regionTop, 0.0f, this.uCenter, 0.0f, this.vMiddle, alpha);
        this.patch(buf, matrix, x + width, y, -this.regionRight, this.regionTop, this.uRight, 1.0f, 0.0f, this.vMiddle, alpha);
        this.patch(buf, matrix, x, y + height, this.regionLeft, -this.regionBottom, 0.0f, this.uCenter, this.vBottom, 1.0f, alpha);
        this.patch(buf, matrix, x + width, y + height, -this.regionRight, -this.regionBottom, this.uRight, 1.0f, this.vBottom, 1.0f, alpha);
        int centerX = x + this.regionLeft;
        int centerY = y + this.regionTop;
        int centerWidth = width - (this.regionLeft + this.regionRight);
        int centerHeight = height - (this.regionTop + this.regionBottom);
        block0 : switch (this.mode.ordinal()) {
            case 0: {
                int regionCenter = this.textureWidth - (this.regionLeft + this.regionRight);
                int regionMiddle = this.textureHeight - (this.regionTop + this.regionBottom);
                int maxX = Math.max(x + width - this.regionRight, 0);
                int maxY = Math.max(y + height - this.regionBottom, 0);
                for (int cx = centerX; cx < maxX; cx += regionCenter) {
                    int clampedCenter = Math.min(regionCenter, maxX - cx);
                    float uCenter1 = (float)(this.regionLeft + clampedCenter) / (float)this.textureWidth;
                    this.patch(buf, matrix, cx, y, clampedCenter, this.regionTop, this.uCenter, uCenter1, 0.0f, this.vMiddle, alpha);
                    this.patch(buf, matrix, cx, maxY, clampedCenter, this.regionBottom, this.uCenter, uCenter1, this.vBottom, 1.0f, alpha);
                    for (int cy = centerY; cy < maxY; cy += regionMiddle) {
                        int clampedMiddle = Math.min(regionMiddle, maxY - cy);
                        float vMiddle1 = (float)(this.regionTop + clampedMiddle) / (float)this.textureWidth;
                        if (cx == centerX) {
                            this.patch(buf, matrix, x, cy, this.regionLeft, clampedMiddle, 0.0f, this.uCenter, this.vMiddle, vMiddle1, alpha);
                            this.patch(buf, matrix, centerX + centerWidth, cy, this.regionRight, clampedMiddle, this.uRight, 1.0f, this.vMiddle, vMiddle1, alpha);
                        }
                        this.patch(buf, matrix, cx, cy, clampedCenter, clampedMiddle, this.uCenter, uCenter1, this.vMiddle, vMiddle1, alpha);
                        if (regionMiddle <= 0) break;
                    }
                    if (regionCenter <= 0) break block0;
                }
                break;
            }
            case 1: {
                this.patch(buf, matrix, centerX, y, centerWidth, this.regionTop, this.uCenter, this.uRight, 0.0f, this.vMiddle, alpha);
                this.patch(buf, matrix, x, centerY, this.regionLeft, centerHeight, 0.0f, this.uCenter, this.vMiddle, this.vBottom, alpha);
                this.patch(buf, matrix, centerX, centerY, centerWidth, centerHeight, this.uCenter, this.uRight, this.vMiddle, this.vBottom, alpha);
                this.patch(buf, matrix, centerX + centerWidth, centerY, this.regionRight, centerHeight, this.uRight, 1.0f, this.vMiddle, this.vBottom, alpha);
                this.patch(buf, matrix, centerX, centerY + centerHeight, centerWidth, this.regionBottom, this.uCenter, this.uRight, this.vBottom, 1.0f, alpha);
            }
        }
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
    }

    private void patch(BufferBuilder buf, Matrix4f matrix, int x0, int y0, int w, int h, float u0, float u1, float v0, float v1, int alpha) {
        if (w == 0 || h == 0) {
            return;
        }
        int x1 = x0 + w;
        int y1 = y0 + h;
        if (x1 < x0) {
            int x0r = x0;
            x0 = x1;
            x1 = x0r;
        }
        if (y1 < y0) {
            int y0r = y0;
            y0 = y1;
            y1 = y0r;
        }
        buf.addVertex(matrix, (float)x0, (float)y1, 0.0f).setUv(u0, v1).setColor(255, 255, 255, alpha);
        buf.addVertex(matrix, (float)x1, (float)y1, 0.0f).setUv(u1, v1).setColor(255, 255, 255, alpha);
        buf.addVertex(matrix, (float)x1, (float)y0, 0.0f).setUv(u1, v0).setColor(255, 255, 255, alpha);
        buf.addVertex(matrix, (float)x0, (float)y0, 0.0f).setUv(u0, v0).setColor(255, 255, 255, alpha);
    }

    public static enum Mode {
        TILE,
        STRETCH;

    }
}

