/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import com.google.gson.GsonBuilder;
import java.nio.file.Path;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.__internal__.IHarvestService;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.DebugConfig;
import mcp.mobius.waila.config.JsonConfig;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.config.input.KeyBind;
import mcp.mobius.waila.gui.hud.theme.ThemeDefinition;
import mcp.mobius.waila.plugin.PluginLoader;
import mcp.mobius.waila.plugin.PluginSide;
import mcp.mobius.waila.registry.RegistryFilter;
import mcp.mobius.waila.service.ICommonService;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.UnsupportedPlatformException;
import net.minecraft.class_2960;

public abstract class Waila {
    private static final Log LOG = Log.create();
    public static final boolean DEV = ICommonService.INSTANCE.isDev();
    public static final boolean CLIENT_SIDE = ICommonService.INSTANCE.getSide().matches(PluginSide.CLIENT);
    public static final boolean ENABLE_DEBUG_COMMAND = DEV || Boolean.getBoolean("waila.debugCommands");
    private static final String ALLOW_UNSUPPORTED_PLATFORMS_KEY = "waila.allowUnsupportedPlatforms";
    public static final boolean ALLOW_UNSUPPORTED_PLATFORMS = Boolean.getBoolean("waila.allowUnsupportedPlatforms");
    public static final Path GAME_DIR = ICommonService.INSTANCE.getGameDir();
    public static final Path CONFIG_DIR = ICommonService.INSTANCE.getConfigDir();
    public static final IJsonConfig<WailaConfig> CONFIG = IJsonConfig.of(WailaConfig.class).file("waila/waila").version(1, WailaConfig::getConfigVersion, WailaConfig::setConfigVersion).json5().commenter(WailaConfig.COMMENTER).gson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(WailaConfig.Overlay.Color.class, (Object)new WailaConfig.Overlay.Color.Adapter()).registerTypeAdapter(ThemeDefinition.class, (Object)new ThemeDefinition.Adapter()).registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(KeyBind.class, (Object)new KeyBind.Adapter()).create()).build();
    public static final IJsonConfig<BlacklistConfig> BLACKLIST_CONFIG = IJsonConfig.of(BlacklistConfig.class).file("waila/blacklist").version(0, BlacklistConfig::getConfigVersion, BlacklistConfig::setConfigVersion).json5().commenter(() -> BlacklistConfig.COMMENTER).gson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BlacklistConfig.class, (Object)new BlacklistConfig.Adapter()).create()).build();
    public static final IJsonConfig<DebugConfig> DEBUG_CONFIG = IJsonConfig.of(DebugConfig.class).file("waila/debug").json5().build();
    private static volatile boolean firstTicked = false;

    public static class_2960 id(String path) {
        return new class_2960("waila", path);
    }

    static void onAnyTick() {
        if (!firstTicked && PluginLoader.INSTANCE.initialized) {
            firstTicked = true;
            JsonConfig.reloadAllInstances();
            PluginConfig.write();
        }
    }

    protected static void onServerStopped() {
        RegistryFilter.attach(null);
    }

    protected static void onTagReload() {
        IHarvestService.INSTANCE.resetCache();
    }

    protected static void unsupportedPlatform(String platformName, String loaderName, String clazz) {
        try {
            Class.forName(clazz);
            String runningPlatformName = ICommonService.INSTANCE.getPlatformName();
            if (!ALLOW_UNSUPPORTED_PLATFORMS) {
                throw new UnsupportedPlatformException("%1$s detected.\n\t\tYou appear to be using the %3$s version of %4$s with %2$s, which is unsupported.\n\t\tPlease use a version of %4$s that specifically made for %2$s instead.\n\t\tRun with -D%5$s=true JVM arg if you know what you are doing.".formatted(loaderName, platformName, runningPlatformName, "WTHIT", ALLOW_UNSUPPORTED_PLATFORMS_KEY));
            }
            LOG.warn("Running on unsupported platform {}, you are on your own.", platformName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

