/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.util.WRenders;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.joml.Matrix4f;

@ApiSide.ClientOnly
public class BarComponent
implements ITooltipComponent {
    static final int WIDTH = 100;
    static final int HEIGHT = 11;
    private static final float U0 = 0.0859375f;
    static final float U1 = 0.4765625f;
    static final float V0_BG = 0.0f;
    static final float V1_BG = 0.04296875f;
    private static final float V0_FG = 0.04296875f;
    private static final float V1_FG = 0.0859375f;
    private static final float UV_W = 0.390625f;
    private final float ratio;
    private final int color;
    private final Component text;

    public BarComponent(float ratio, int color) {
        this(ratio, color, CommonComponents.EMPTY);
    }

    public BarComponent(float ratio, int color, String text) {
        this(ratio, color, (Component)Component.literal((String)text));
    }

    public BarComponent(float ratio, int color, Component text) {
        this.ratio = ratio;
        this.color = color;
        this.text = text;
    }

    @Override
    public int getWidth() {
        return Math.max(Minecraft.getInstance().font.width((FormattedText)this.text), 100);
    }

    @Override
    public int getHeight() {
        return 11;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        BarComponent.renderBar(ctx, x, y, 100.0f, 0.0f, 0.4765625f, 0.04296875f, this.color);
        BarComponent.renderBar(ctx, x, y, 100.0f * this.ratio, 0.04296875f, 0.0859375f + 0.390625f * this.ratio, 0.0859375f, this.color);
        BarComponent.renderText(ctx, this.text, x, y);
    }

    static void renderBar(GuiGraphics ctx, int x, int y, float w, float v0, float u1, float v1, int tint) {
        PoseStack ps = ctx.pose();
        ps.pushPose();
        int a = ARGB.alpha((int)tint);
        int r = ARGB.red((int)tint);
        int g = ARGB.green((int)tint);
        int b = ARGB.blue((int)tint);
        VertexConsumer buffer = WRenders.buffer(ctx, RenderType.guiTextured((ResourceLocation)WailaConstants.COMPONENT_TEXTURE));
        Matrix4f pose = ps.last().pose();
        buffer.addVertex(pose, (float)x, (float)(y + 11), 0.0f).setUv(0.0859375f, v1).setColor(r, g, b, a);
        buffer.addVertex(pose, (float)x + w, (float)(y + 11), 0.0f).setUv(u1, v1).setColor(r, g, b, a);
        buffer.addVertex(pose, (float)x + w, (float)y, 0.0f).setUv(u1, v0).setColor(r, g, b, a);
        buffer.addVertex(pose, (float)x, (float)y, 0.0f).setUv(0.0859375f, v0).setColor(r, g, b, a);
        ps.popPose();
        ctx.flush();
    }

    static void renderText(GuiGraphics ctx, Component text, int x, int y) {
        MultiBufferSource bufferSource = WRenders.bufferSource(ctx);
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width((FormattedText)text);
        float textX = (float)x + Math.max((float)(100 - textWidth) / 2.0f, 0.0f);
        float textY = y + 2;
        font.drawInBatch8xOutline(text.getVisualOrderText(), textX, textY, 0xAAAAAA, 0x292929, ctx.pose().last().pose(), bufferSource, 0xF000F0);
        ctx.flush();
    }
}

