/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import java.util.Locale;
import java.util.function.Consumer;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class EnumValue<T extends Enum<T>>
extends ConfigValue<T> {
    private final Button button;

    public EnumValue(String optionName, T[] values, T selected, @Nullable T defaultValue, Consumer<T> save) {
        super(optionName, selected, defaultValue, save);
        this.button = DisplayUtil.createButton(0, 0, 100, 20, (Component)Component.translatable((String)(optionName + "_" + ((Enum)selected).name().toLowerCase(Locale.ROOT))), w -> this.setValue(values[(((Enum)this.getValue()).ordinal() + 1) % values.length]));
    }

    @Override
    protected void drawValue(GuiGraphics ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.button.active = !this.isDisabled();
        this.button.setX(x + width - this.button.getWidth());
        this.button.setY(y + (height - this.button.getHeight()) / 2);
        this.button.setMessage((Component)Component.translatable((String)this.getValueTlKey()));
        this.button.render(ctx, mouseX, mouseY, partialTicks);
    }

    @Override
    public GuiEventListener getListener() {
        return this.button;
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        super.buildSearchKey(sb);
        sb.append(" ").append(I18n.get((String)this.getValueTlKey(), (Object[])new Object[0]));
    }

    private String getValueTlKey() {
        return this.translationKey + "_" + ((Enum)this.getValue()).name().toLowerCase(Locale.ROOT);
    }
}

