/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.data.FluidData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class FluidDataImpl
extends FluidData.PlatformDependant<Object> {
    private static final StreamCodec<RegistryFriendlyByteBuf, Fluid> FLUID_CODEC = ByteBufCodecs.registry((ResourceKey)Registries.FLUID);
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidDataImpl> CODEC = StreamCodec.ofMember((d, buf) -> {
        buf.writeEnum((Enum)d.unit);
        buf.writeVarInt(d.entries.size());
        for (Entry<?> entry : d.entries) {
            if (entry.isEmpty()) {
                buf.writeBoolean(true);
                continue;
            }
            buf.writeBoolean(false);
            FLUID_CODEC.encode(buf, entry.fluid);
            DataComponentPatch.STREAM_CODEC.encode(buf, (Object)entry.data);
            buf.writeDouble(entry.stored);
            buf.writeDouble(entry.capacity);
        }
    }, buf -> {
        FluidData.Unit unit = (FluidData.Unit)buf.readEnum(FluidData.Unit.class);
        int size = buf.readVarInt();
        FluidDataImpl d = new FluidDataImpl(null, unit, size);
        for (int i = 0; i < size; ++i) {
            if (buf.readBoolean()) continue;
            Fluid fluid = (Fluid)FLUID_CODEC.decode(buf);
            DataComponentPatch data = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode(buf);
            double stored = buf.readDouble();
            double capacity = buf.readDouble();
            d.add(fluid, data, stored, capacity);
        }
        return d;
    });
    private final List<Entry<?>> entries;
    private final FluidData.PlatformTranslator<Object> proxy;
    private final FluidData.Unit unit;

    public FluidDataImpl(@Nullable FluidData.PlatformTranslator<Object> proxy, FluidData.Unit unit, int slotCountHint) {
        this.entries = slotCountHint == -1 ? new ArrayList() : new ArrayList(slotCountHint);
        this.proxy = proxy;
        this.unit = unit;
    }

    @Override
    protected void implAdd(Fluid fluid, DataComponentPatch data, double stored, double capacity) {
        this.entries.add(new Entry<Fluid>(fluid, data, stored, capacity));
    }

    @Override
    protected FluidData.PlatformTranslator<Object> translator() {
        return this.proxy;
    }

    @Override
    public IData.Type<? extends IData> type() {
        return TYPE;
    }

    public FluidData.Unit unit() {
        return this.unit;
    }

    public List<Entry<?>> entries() {
        return this.entries;
    }

    public static class Entry<T extends Fluid>
    implements FluidData.FluidDescriptionContext<T> {
        private final T fluid;
        private final DataComponentPatch data;
        private final double stored;
        private final double capacity;

        private Entry(T fluid, DataComponentPatch data, double stored, double capacity) {
            this.fluid = fluid;
            this.data = data;
            this.stored = stored;
            this.capacity = capacity;
        }

        public boolean isEmpty() {
            return this.fluid == Fluids.EMPTY || this.stored <= 0.0;
        }

        @Override
        public T fluid() {
            return this.fluid;
        }

        @Override
        public DataComponentPatch data() {
            return this.data;
        }

        public double stored() {
            return this.stored;
        }

        public double capacity() {
            return this.capacity;
        }
    }

    public static class FluidDescription
    implements FluidData.FluidDescription {
        public static final Map<Fluid, FluidData.FluidDescriptor<Fluid>> FLUID_STATIC = new HashMap<Fluid, FluidData.FluidDescriptor<Fluid>>();
        public static final Map<Class<?>, FluidData.FluidDescriptor<Fluid>> FLUID_DYNAMIC = new HashMap();
        public static final Map<Block, FluidData.CauldronDescriptor> CAULDRON_STATIC = new HashMap<Block, FluidData.CauldronDescriptor>();
        public static final Map<Class<?>, FluidData.CauldronDescriptor> CAULDRON_DYNAMIC = new HashMap();
        private static final FluidDescription INSTANCE = new FluidDescription();
        private static final Component UNKNOWN_FLUID_NAME = Component.translatable((String)"tooltip.waila.extra.unknown_fluid");
        private static final FluidData.FluidDescriptor<Fluid> UNKNOWN_FLUID_DESC = (ctx, desc) -> {};
        private static final FluidData.CauldronDescriptor NULL_CAULDRON_DESC = state -> null;
        private TextureAtlasSprite sprite;
        private int tint;
        private Component name;

        public static FluidDescription getFluidDesc(Entry<?> entry) {
            Object fluid = entry.fluid();
            FluidData.FluidDescriptor<Fluid> descriptor = FLUID_STATIC.get(fluid);
            if (descriptor == null) {
                for (Class<?> clazz = fluid.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                    descriptor = FLUID_DYNAMIC.get(clazz);
                    if (descriptor == null) continue;
                    FLUID_DYNAMIC.put(fluid.getClass(), descriptor);
                    break;
                }
            }
            if (descriptor == null) {
                descriptor = UNKNOWN_FLUID_DESC;
                FLUID_STATIC.put((Fluid)fluid, UNKNOWN_FLUID_DESC);
            }
            INSTANCE.sprite(Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(Blocks.WATER.defaultBlockState()).particleIcon()).tint(-1).name(UNKNOWN_FLUID_NAME);
            descriptor.describeFluid(entry, INSTANCE);
            return INSTANCE;
        }

        @Nullable
        public static FluidData getCauldronFluidData(BlockState state) {
            Block block = state.getBlock();
            FluidData.CauldronDescriptor getter = CAULDRON_STATIC.get(block);
            if (getter == null) {
                for (Class<?> clazz = block.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                    getter = CAULDRON_DYNAMIC.get(clazz);
                    if (getter == null) continue;
                    CAULDRON_DYNAMIC.put(block.getClass(), getter);
                    break;
                }
            }
            if (getter == null) {
                getter = NULL_CAULDRON_DESC;
                CAULDRON_STATIC.put(block, NULL_CAULDRON_DESC);
            }
            return getter.getCauldronFluidData(state);
        }

        public Component name() {
            return this.name;
        }

        public TextureAtlasSprite sprite() {
            return this.sprite;
        }

        public int tint() {
            return this.tint;
        }

        @Override
        public FluidDescription name(Component name) {
            this.name = name;
            return this;
        }

        @Override
        public FluidDescription sprite(TextureAtlasSprite sprite) {
            this.sprite = sprite;
            return this;
        }

        @Override
        public FluidDescription tint(int argb) {
            this.tint = argb;
            return this;
        }
    }
}

