/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Random;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.util.WRenders;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public abstract class ComponentRenderer {
    private static final Random RANDOM = new Random();
    @Nullable
    private static ComponentRenderer current = null;

    public abstract void render(class_332 var1, ITooltipComponent var2, int var3, int var4, int var5, int var6, class_9779 var7);

    public static ComponentRenderer get() {
        if (current == null) {
            current = Default.INSTANCE;
        }
        return current;
    }

    public static void set(@Nullable ComponentRenderer value) {
        if (value == null) {
            value = Default.INSTANCE;
        }
        current = value;
    }

    public static class Default
    extends ComponentRenderer {
        public static final Default INSTANCE = new Default();

        @Override
        public void render(class_332 ctx, ITooltipComponent component, int x, int y, int cw, int ch, class_9779 delta) {
            component.render(ctx, x, y, delta);
            if (WailaClient.showComponentBounds) {
                ctx.method_71048();
                Default.renderBounds(ctx, x, y, cw, ch, 1.0f);
            }
        }

        public static void renderBounds(class_332 ctx, int x, int y, int cw, int ch, float v) {
            ctx.method_51448().pushMatrix();
            float scale = class_310.method_1551().method_22683().method_4495();
            ctx.method_51448().scale(1.0f / scale, 1.0f / scale);
            int bx = class_3532.method_15357((double)((double)((float)x * scale) + 0.5));
            int by = class_3532.method_15357((double)((double)((float)y * scale) + 0.5));
            int bw = class_3532.method_15357((double)((double)((float)cw * scale) + 0.5));
            int bh = class_3532.method_15357((double)((double)((float)ch * scale) + 0.5));
            int color = -16777216 + class_3532.method_15369((float)RANDOM.nextFloat(), (float)RANDOM.nextFloat(), (float)v);
            WRenders.state(ctx).method_70919((class_11244)new BoundsRenderState(new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), new class_8030(bx, by, bw, bh), color));
            ctx.method_51448().popMatrix();
        }
    }

    private static final class BoundsRenderState
    extends Record
    implements class_11244 {
        private final Matrix3x2f pose;
        private final class_8030 bounds;
        private final int color;

        private BoundsRenderState(Matrix3x2f pose, class_8030 bounds, int color) {
            this.pose = pose;
            this.bounds = bounds;
            this.color = color;
        }

        public void method_70917(class_4588 buf) {
            DisplayUtil.renderRectBorder(this.pose, buf, this.bounds.method_49620(), this.bounds.method_49618(), this.bounds.comp_1196(), this.bounds.comp_1197(), 1, this.color, this.color);
        }

        public RenderPipeline comp_4055() {
            return class_10799.field_56879;
        }

        public class_11231 comp_4056() {
            return class_11231.method_70899();
        }

        @Nullable
        public class_8030 comp_4069() {
            return null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BoundsRenderState.class, "pose;bounds;color", "pose", "bounds", "color"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BoundsRenderState.class, "pose;bounds;color", "pose", "bounds", "color"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BoundsRenderState.class, "pose;bounds;color", "pose", "bounds", "color"}, this, o);
        }

        public Matrix3x2f pose() {
            return this.pose;
        }

        public class_8030 comp_4274() {
            return this.bounds;
        }

        public int color() {
            return this.color;
        }
    }
}

