/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.service;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataType;
import mcp.mobius.waila.api.IBlacklistConfig;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.IRegistryFilter;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.config.JsonConfig;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.hud.theme.ThemeType;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.registry.InstanceRegistry;
import mcp.mobius.waila.registry.RegistryFilter;
import mcp.mobius.waila.service.MixinService;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.ModInfo;
import net.minecraft.class_11580;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1826;
import net.minecraft.class_1833;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9886;

public abstract class ApiService
implements IApiService {
    private static final Log LOG = Log.create();

    @Override
    public IModInfo getModInfo(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if ("minecraft".equals(class_7923.field_41178.method_10221((Object)item).method_12836())) {
            class_11580 customData;
            class_9304 enchantments = (class_9304)stack.method_58695(class_9334.field_49643, (Object)class_9304.field_49385);
            if (enchantments.method_57541() == 1) {
                Object2IntMap.Entry entry;
                class_5321 key;
                Iterator iterator = enchantments.method_57539().iterator();
                if (iterator.hasNext() && (key = (class_5321)((class_6880)(entry = (Object2IntMap.Entry)iterator.next()).getKey()).method_40230().orElse(null)) != null) {
                    return IModInfo.get(key.method_29177());
                }
            } else if (item instanceof class_1812 || item instanceof class_1833) {
                class_2960 id;
                class_6880 potion = ((class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274)).comp_2378().orElse(null);
                if (potion != null && (id = class_7923.field_41179.method_10221((Object)((class_1842)potion.comp_349()))) != null) {
                    return IModInfo.get(id);
                }
            } else if (item instanceof class_1826 && (customData = (class_11580)stack.method_58694(class_9334.field_49609)) != null) {
                return IModInfo.get((class_1299)customData.method_72530());
            }
        }
        return IModInfo.get(item);
    }

    @Override
    public IBlacklistConfig getBlacklistConfig() {
        return Waila.BLACKLIST_CONFIG.get().getView();
    }

    @Override
    public <T> IJsonConfig.Builder0<T> createConfigBuilder(Type type) {
        return new JsonConfig.Builder(type);
    }

    @Override
    public IModInfo getModInfo(String namespace) {
        return ModInfo.get(namespace);
    }

    @Override
    public IPluginInfo getPluginInfo(class_2960 pluginId) {
        return PluginInfo.get(pluginId);
    }

    @Override
    public Collection<IPluginInfo> getAllPluginInfoFromMod(String modId) {
        return PluginInfo.getAllFromMod(modId);
    }

    @Override
    public Collection<IPluginInfo> getAllPluginInfo() {
        return PluginInfo.getAll();
    }

    @Override
    public IWailaConfig getConfig() {
        return Waila.CONFIG.get();
    }

    @Override
    public int getPairComponentColonOffset() {
        return TooltipRenderer.colonOffset;
    }

    @Override
    public int getColonFontWidth() {
        return TooltipRenderer.colonWidth;
    }

    @Override
    public int getFontColor() {
        return TooltipRenderer.state.getTheme().getDefaultTextColor() | 0xFF000000;
    }

    @Override
    public <T extends ITheme> IThemeType.Builder<T> createThemeTypeBuilder(Class<T> clazz) {
        return new ThemeType<T>(clazz);
    }

    @Override
    public String getDefaultEnergyUnit() {
        return "E";
    }

    @Override
    public Path getConfigDir() {
        return Waila.CONFIG_DIR;
    }

    @Override
    public <T> IRegistryFilter.Builder<T> createRegistryFilterBuilder(class_5321<? extends class_2378<T>> registryKey) {
        return new RegistryFilter.Builder(registryKey);
    }

    @Override
    public <T> IInstanceRegistry<T> createInstanceRegistry(boolean reversed) {
        InstanceRegistry registry = new InstanceRegistry();
        if (reversed) {
            registry.reversed();
        }
        return registry;
    }

    @Override
    public List<class_9886> getTiers() {
        return MixinService.TOOL_MATERIALS.stream().filter(it -> {
            if (it.comp_2930() == null) {
                LOG.warn("Found tier of class [{}] with null inverse tag, skipping", it.getClass().getName());
                return false;
            }
            return true;
        }).sorted((tier1, tier2) -> {
            class_6862 tag1 = tier1.comp_2930();
            class_6862 tag2 = tier2.comp_2930();
            Optional opt1 = class_7923.field_41175.method_46733(tag1);
            Optional opt2 = class_7923.field_41175.method_46733(tag2);
            class_6885 blocks1 = opt1.isPresent() ? (class_6885)opt1.get() : class_6885.method_58563();
            class_6885 blocks2 = opt2.isPresent() ? (class_6885)opt2.get() : class_6885.method_58563();
            int size1 = blocks1.method_40247();
            int size2 = blocks2.method_40247();
            if (size1 == 0 && size2 == 0) {
                return 0;
            }
            if (size1 == 0) {
                return 1;
            }
            if (size2 == 0) {
                return -1;
            }
            boolean b1inB2 = blocks1.method_40239().allMatch(arg_0 -> ((class_6885)blocks2).method_40241(arg_0));
            boolean b2inB1 = blocks2.method_40239().allMatch(arg_0 -> ((class_6885)blocks1).method_40241(arg_0));
            if (b1inB2 && b2inB1) {
                return 0;
            }
            if (b1inB2) {
                return 1;
            }
            if (b2inB1) {
                return -1;
            }
            String blocks1str = ApiService.concatBlocks((class_6885<class_2248>)blocks1);
            String blocks2str = ApiService.concatBlocks((class_6885<class_2248>)blocks2);
            LOG.error("Unsolvable tier comparison!\nEither one of [{}] or [{}] does not contain all entries from the other one.\nThe comparison is based on the assumption that lower tier's incorrect block tag contains all entries from higher tier's tag.\nThis was fine for Vanilla, but might be not match modded behavior.\nPlease open an issue at {}\nTag [{}] contains:\n\t[{}]\nTag [{}] contains:\n\t[{}]\n", tag1.comp_327(), tag2.comp_327(), Waila.ISSUE_URL, tag1.comp_327(), blocks1str, tag2.comp_327(), blocks2str);
            return 0;
        }).toList();
    }

    public static String concatBlocks(class_6885<class_2248> set) {
        return String.join((CharSequence)"\n\t", set.method_40239().map(it -> ((class_5321)it.method_40230().orElseThrow()).method_29177().toString()).sorted().toList());
    }

    @Override
    public <D extends IData> IData.Type<D> createDataType(class_2960 id) {
        return new DataType(id);
    }

    @Override
    public boolean isDevEnv() {
        return Waila.DEV;
    }
}

