/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config.input;

import com.google.common.collect.MapMaker;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.blaze3d.platform.InputConstants;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public final class KeyBind {
    private static final Map<InputConstants.Key, KeyBind> INSTANCES = new MapMaker().weakValues().makeMap();
    public static final KeyBind UNKNOWN = KeyBind.of(InputConstants.UNKNOWN);
    private final InputConstants.Key key;
    private boolean pendingPressed;
    private boolean pressed;
    private boolean wasPressed;

    private KeyBind(InputConstants.Key key) {
        this.key = key;
    }

    public static KeyBind of(InputConstants.Key key) {
        return INSTANCES.computeIfAbsent(key, KeyBind::new);
    }

    public static void set(InputConstants.Key key, boolean pressed) {
        KeyBind bind = INSTANCES.get(key);
        if (bind == null) {
            return;
        }
        bind.pendingPressed = pressed;
    }

    public static void tick() {
        for (KeyBind instance : INSTANCES.values()) {
            instance.wasPressed = instance.pressed;
            instance.pressed = instance.pendingPressed;
        }
    }

    public boolean isDown() {
        return this.pressed;
    }

    public boolean isPressed() {
        return this.pressed && !this.wasPressed;
    }

    public InputConstants.Key key() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyBind bind = (KeyBind)o;
        return Objects.equals(this.key, bind.key);
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    public String toString() {
        return this.key.getName();
    }

    public static class Adapter
    implements JsonSerializer<KeyBind>,
    JsonDeserializer<KeyBind> {
        public KeyBind deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return KeyBind.of(InputConstants.getKey((String)json.getAsString()));
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public JsonElement serialize(KeyBind src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.key.getName());
        }
    }
}

