/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.forge.fluid;

import java.util.Optional;
import mcp.mobius.waila.api.data.FluidData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.AtlasIds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public enum ForgeFluidDescriptor implements FluidData.FluidDescriptor<Fluid>
{
    INSTANCE;


    @Override
    public void describeFluid(FluidData.FluidDescriptionContext<Fluid> ctx, FluidData.FluidDescription desc) {
        Optional customData = ctx.data().get(DataComponents.CUSTOM_DATA);
        CompoundTag nbt = customData != null && customData.isPresent() ? ((CustomData)customData.get()).copyTag() : null;
        FluidStack stack = new FluidStack(ctx.fluid(), 1);
        stack.setTag(nbt);
        FluidType type = ctx.fluid().getFluidType();
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((FluidType)type);
        TextureAtlas atlas = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS);
        desc.name(type.getDescription(stack)).sprite(atlas.getSprite(extensions.getStillTexture(stack))).tint(extensions.getTintColor(stack));
    }
}

