/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.util.OptionalInt;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.mixin.ChiseledBookShelfBlockAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import mcp.mobius.waila.plugin.vanilla.provider.ItemEntityProvider;
import mcp.mobius.waila.plugin.vanilla.provider.data.ChiseledBookShelfDataProvider;
import net.minecraft.class_1799;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public enum ChiseledBookShelfProvider implements IBlockComponentProvider
{
    INSTANCE;

    private int lastUpdateId = 0;
    private class_1799 hitItem = class_1799.field_8037;

    private void init(IBlockAccessor accessor, IPluginConfig config) {
        if (this.lastUpdateId == accessor.getUpdateId()) {
            return;
        }
        this.lastUpdateId = accessor.getUpdateId();
        this.hitItem = class_1799.field_8037;
        if (!config.getBoolean(Options.BOOK_BOOKSHELF)) {
            return;
        }
        ChiseledBookShelfDataProvider.Data data = accessor.getData().get(ChiseledBookShelfDataProvider.DATA);
        if (data == null) {
            return;
        }
        ChiseledBookShelfBlockAccess block = (ChiseledBookShelfBlockAccess)accessor.getBlock();
        OptionalInt hitSlot = block.wthit_getHitSlot(accessor.getBlockHitResult(), accessor.getBlockState());
        if (hitSlot.isEmpty()) {
            return;
        }
        this.hitItem = data.items().get(hitSlot.getAsInt());
    }

    @Override
    @Nullable
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.method_7960()) {
            return null;
        }
        return new ItemComponent(this.hitItem);
    }

    @Override
    public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.method_7960()) {
            return;
        }
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(this.hitItem.method_7964()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(class_7923.field_41178.method_10221((Object)this.hitItem.method_7909())));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.method_7960()) {
            return;
        }
        ItemEntityProvider.appendBookProperties(tooltip, this.hitItem, config);
    }

    @Override
    public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.method_7960()) {
            return;
        }
        if (!config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            return;
        }
        tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(IModInfo.get(this.hitItem).getName()));
    }
}

