/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import mcp.mobius.waila.api.ICommonRegistrar;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.component.BarComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.api.data.EnergyData;
import mcp.mobius.waila.plugin.extra.data.EnergyDataImpl;
import mcp.mobius.waila.plugin.extra.provider.DataProvider;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EnergyProvider
extends DataProvider<EnergyData, EnergyDataImpl> {
    public static final EnergyProvider INSTANCE = new EnergyProvider();
    private static final String INFINITE = "\u221e";
    private static final ResourceLocation INFINITE_TAG_ID = new ResourceLocation("waila", "extra/infinite_energy");
    private static final TagKey<Block> INFINITE_BLOCK_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)INFINITE_TAG_ID);
    private static final TagKey<BlockEntityType<?>> INFINITE_BLOCK_ENTITY_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122907_, (ResourceLocation)INFINITE_TAG_ID);
    private static final TagKey<EntityType<?>> INFINITE_ENTITY_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)INFINITE_TAG_ID);

    private EnergyProvider() {
        super(EnergyData.ID, EnergyData.class, EnergyDataImpl.class, EnergyDataImpl::new);
    }

    @Override
    protected void registerAdditions(ICommonRegistrar registrar, int priority) {
        registrar.blockData(new InfiniteEnergyBlockProvider(), BlockEntity.class, 1);
        registrar.entityData(new InfiniteEnergyEntityProvider(), Entity.class, 1);
    }

    @Override
    protected void appendBody(ITooltip tooltip, EnergyDataImpl energy, IPluginConfig config, ResourceLocation objectId) {
        Object text;
        EnergyDataImpl.Description desc = EnergyDataImpl.Description.get(objectId.m_135827_());
        double stored = energy.stored();
        double capacity = energy.capacity();
        float ratio = Double.isInfinite(capacity) ? 1.0f : (float)(stored / capacity);
        String unit = desc.unit();
        Component name = desc.name();
        int color = desc.color();
        if (Double.isInfinite(stored)) {
            text = INFINITE;
        } else {
            text = WailaHelper.suffix((long)stored);
            if (Double.isFinite(capacity)) {
                text = (String)text + "/" + WailaHelper.suffix((long)capacity);
            }
        }
        if (!unit.isEmpty()) {
            text = (String)text + " " + unit;
        }
        tooltip.setLine(EnergyData.ID, new PairComponent(new WrappedComponent(name), new BarComponent(ratio, 0xFF000000 | color, (String)text)));
    }

    private static class InfiniteEnergyBlockProvider
    implements IDataProvider<BlockEntity> {
        private InfiniteEnergyBlockProvider() {
        }

        @Override
        public void appendData(IDataWriter data, IServerAccessor<BlockEntity> accessor, IPluginConfig config) {
            data.add(EnergyData.class, res -> {
                BlockEntity target = (BlockEntity)accessor.getTarget();
                if (target.m_58900_().m_204336_(INFINITE_BLOCK_TAG) || Registry.f_122830_.m_214121_((ResourceKey)Registry.f_122830_.m_7854_((Object)target.m_58903_()).orElseThrow()).m_203656_(INFINITE_BLOCK_ENTITY_TAG)) {
                    res.add(EnergyData.INFINITE);
                }
            });
        }
    }

    private static class InfiniteEnergyEntityProvider
    implements IDataProvider<Entity> {
        private InfiniteEnergyEntityProvider() {
        }

        @Override
        public void appendData(IDataWriter data, IServerAccessor<Entity> accessor, IPluginConfig config) {
            data.add(EnergyData.class, res -> {
                if (((Entity)accessor.getTarget()).m_6095_().m_204039_(INFINITE_ENTITY_TAG)) {
                    res.add(EnergyData.INFINITE);
                }
            });
        }
    }
}

