/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public enum PlantProvider implements IBlockComponentProvider
{
    INSTANCE;


    private static void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        ITooltipLine line = tooltip.setLine(Options.PLANT_CROP_PROGRESS);
        if ((growthValue *= 100.0f) < 100.0f) {
            line.with(new PairComponent((Component)Component.translatable((String)"tooltip.waila.crop_growth"), (Component)Component.literal((String)String.format("%.0f%%", Float.valueOf(growthValue)))));
        } else {
            line.with(new PairComponent((Component)Component.translatable((String)"tooltip.waila.crop_growth"), (Component)Component.translatable((String)"tooltip.waila.crop_mature")));
        }
    }

    private static void addGrowableTooltip(ITooltip tooltip, ResourceLocation tag, String translationKey, boolean growable) {
        tooltip.setLine(tag, new PairComponent((Component)Component.translatable((String)translationKey), (Component)(growable ? Component.translatable((String)"tooltip.waila.true") : Component.translatable((String)"tooltip.waila.false"))));
    }

    private static void addCropGrowableTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        int lightLevel = accessor.getWorld().getRawBrightness(accessor.getPosition(), 0);
        PlantProvider.addGrowableTooltip(tooltip, Options.PLANT_CROP_GROWABLE, "tooltip.waila.crop_growable", lightLevel >= 9);
    }

    private static void addTreeGrowableTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        boolean growable;
        int lightLevel = accessor.getWorld().getRawBrightness(accessor.getPosition(), 0);
        boolean bl = growable = lightLevel >= 9;
        if (accessor.getBlock() instanceof MangrovePropaguleBlock && ((Boolean)accessor.getBlockState().getValue((Property)MangrovePropaguleBlock.HANGING)).booleanValue()) {
            growable = false;
        }
        PlantProvider.addGrowableTooltip(tooltip, Options.PLANT_TREE_GROWABLE, "tooltip.waila.tree_growable", growable);
    }

    @Override
    @Nullable
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() == Blocks.WHEAT) {
            return new ItemComponent((ItemLike)Items.WHEAT);
        }
        if (accessor.getBlock() == Blocks.BEETROOTS) {
            return new ItemComponent((ItemLike)Items.BEETROOT);
        }
        return null;
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.PLANT_CROP_PROGRESS)) {
            Block block = accessor.getBlock();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                PlantProvider.addMaturityTooltip(tooltip, (float)crop.getAge(accessor.getBlockState()) / (float)crop.getMaxAge());
            } else if (accessor.getBlock() == Blocks.MELON_STEM || accessor.getBlock() == Blocks.PUMPKIN_STEM) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().getValue((Property)BlockStateProperties.AGE_7)).intValue() / 7.0f);
            } else if (accessor.getBlock() == Blocks.COCOA) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().getValue((Property)BlockStateProperties.AGE_2)).intValue() / 2.0f);
            } else if (accessor.getBlock() == Blocks.SWEET_BERRY_BUSH) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().getValue((Property)BlockStateProperties.AGE_3)).intValue() / 3.0f);
            } else if (accessor.getBlock() == Blocks.NETHER_WART) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().getValue((Property)BlockStateProperties.AGE_3)).intValue() / 3.0f);
            }
        }
        if (config.getBoolean(Options.PLANT_CROP_GROWABLE) && (accessor.getBlock() instanceof CropBlock || accessor.getBlock() instanceof StemBlock) && IModInfo.get(accessor.getBlock()).getId().equals("minecraft")) {
            PlantProvider.addCropGrowableTooltip(tooltip, accessor);
        }
        if (config.getBoolean(Options.PLANT_TREE_GROWABLE) && accessor.getBlock() instanceof SaplingBlock && IModInfo.get(accessor.getBlock()).getId().equals("minecraft")) {
            PlantProvider.addTreeGrowableTooltip(tooltip, accessor);
        }
    }
}

