/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget;

import com.google.common.collect.ImmutableList;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public class CategoryEntry
extends ConfigListWidget.Entry {
    private static final IJsonConfig<Map<String, Boolean>> STATES = IJsonConfig.of(new TypeToken<Map<String, Boolean>>(){}).file("waila/category_entries").json5().factory(HashMap::new).commenter(() -> p -> !p.isEmpty() ? null : "This config controls the category entries collapsed state.\nYou shouldn't edit this config by hand.\n").build();
    public final Component title;
    private final String key;
    private final Button collapseButton;
    private final Button expandAllButton;
    private final List<ConfigListWidget.Entry> children = new ArrayList<ConfigListWidget.Entry>();
    private final Set<ConfigValue<?, ?>> hiddenValues = new HashSet();
    private boolean collapsed;
    private boolean hasNested = false;
    private boolean filterMatchParent = false;

    public CategoryEntry(String title) {
        this.key = title;
        this.title = Component.m_237115_((String)title).m_130940_(ChatFormatting.BOLD);
        this.collapseButton = new Button(0, 0, 12, 12, CommonComponents.f_237098_, b -> this.toggleCollapse());
        this.expandAllButton = new Button(0, 0, 20, 12, (Component)Component.m_237113_((String)"++"), b -> {
            this.setCollapse(false, true);
            this.list.init();
            this.list.m_7522_((GuiEventListener)this);
            this.m_7522_((GuiEventListener)b);
        });
        this.collapsed = Boolean.TRUE.equals(STATES.get().putIfAbsent(this.key, false));
        STATES.save();
    }

    public CategoryEntry with(ConfigListWidget.Entry child) {
        child.category = this;
        child.categoryDepth = this.categoryDepth + 1;
        this.children.add(child);
        if (child instanceof CategoryEntry) {
            this.hasNested = true;
        }
        return this;
    }

    public CategoryEntry withHidden(ConfigValue<?, ?> value) {
        this.hiddenValues.add(value);
        return this;
    }

    private void initValues(ConfigListWidget list) {
        for (ConfigListWidget.Entry entry : this.children) {
            if (entry instanceof ConfigValue) {
                ConfigValue value = (ConfigValue)entry;
                list.withHidden(value);
            }
            if (!(entry instanceof CategoryEntry)) continue;
            CategoryEntry cat = (CategoryEntry)entry;
            cat.initValues(list);
        }
        for (ConfigValue configValue : this.hiddenValues) {
            list.withHidden(configValue);
        }
    }

    @Override
    public int init() {
        if (this.category == null) {
            this.initValues(this.list);
        }
        boolean expand = !this.collapsed || this.list.filter != null;
        this.collapseButton.m_93666_((Component)Component.m_237113_((String)(!expand ? "+" : "-")));
        int added = 1;
        boolean matchCategory = StringUtils.containsIgnoreCase((CharSequence)this.title.getString(), (CharSequence)this.list.filter);
        if (this.category != null) {
            boolean bl = matchCategory = matchCategory || this.filterMatchParent;
        }
        if (expand) {
            for (ConfigListWidget.Entry child : this.children) {
                if (child instanceof CategoryEntry) {
                    CategoryEntry nest = (CategoryEntry)child;
                    nest.filterMatchParent = matchCategory;
                }
                if (!matchCategory && this.list.splitFilter != null && !child.match(this.list.splitFilter)) continue;
                this.list.with(this.index + added, child);
                added += child.init(this.list, this.index + added);
            }
        }
        return added;
    }

    @Override
    public void clear(ConfigListWidget list) {
        list.m_6702_().removeIf(it -> it.category == this);
        for (ConfigListWidget.Entry child : this.children) {
            child.clear(list);
        }
    }

    private void setCollapse(boolean collapsed, boolean deep) {
        this.collapsed = collapsed;
        STATES.get().put(this.key, collapsed);
        STATES.save();
        if (deep) {
            for (ConfigListWidget.Entry child : this.children) {
                if (!(child instanceof CategoryEntry)) continue;
                CategoryEntry entry = (CategoryEntry)child;
                entry.setCollapse(collapsed, true);
            }
        }
    }

    private void toggleCollapse() {
        if (!this.collapsed) {
            this.setCollapse(true, true);
        } else {
            this.setCollapse(false, false);
        }
        this.list.init();
        this.list.m_7522_((GuiEventListener)this);
        this.m_7522_((GuiEventListener)this.collapseButton);
    }

    @Override
    protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
        children.add((Object)this.collapseButton);
        children.add((Object)this.expandAllButton);
    }

    @Override
    public void renderTooltip(Screen screen, PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.expandAllButton.m_5953_((double)mouseX, (double)mouseY)) {
            screen.m_96602_(matrices, (Component)Component.m_237115_((String)"config.waila.expand_all"), mouseX, mouseY);
        }
    }

    @Override
    protected void drawEntry(PoseStack matrices, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        int buttonY = rowTop + (height - this.collapseButton.m_93694_()) / 2;
        boolean hasFilter = this.list.filter != null;
        this.collapseButton.f_93623_ = !hasFilter;
        this.collapseButton.f_93620_ = rowLeft;
        this.collapseButton.f_93621_ = buttonY;
        this.collapseButton.m_6305_(matrices, mouseX, mouseY, deltaTime);
        Font font = this.client.f_91062_;
        float f = rowLeft + this.collapseButton.m_5711_() + 4;
        float f2 = rowTop;
        Objects.requireNonNull(this.client.f_91062_);
        font.m_92763_(matrices, this.title, f, f2 + (float)(height - 9) / 2.0f + 1.0f, 0xFFFFFF);
        boolean bl = this.expandAllButton.f_93623_ = this.hasNested && !hasFilter;
        if (this.expandAllButton.f_93623_) {
            this.expandAllButton.f_93620_ = rowLeft + width - this.expandAllButton.m_5711_();
            this.expandAllButton.f_93621_ = buttonY;
            this.expandAllButton.m_6305_(matrices, mouseX, mouseY, deltaTime);
        }
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        sb.append(this.title.getString());
        if (!this.children.isEmpty()) {
            sb.append(" ");
            for (ConfigListWidget.Entry child : this.children) {
                child.buildSearchKey(sb);
            }
        }
    }
}

