/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.data;

import java.util.ArrayList;
import mcp.mobius.waila.api.data.ProgressData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class ProgressDataImpl
extends ProgressData {
    public final boolean hasTick;
    public float ratio;
    public int currentTick;
    public int maxTick;

    @Override
    public void write(FriendlyByteBuf buf) {
        ProgressDataImpl d = this;
        buf.writeBoolean(d.hasTick);
        if (d.hasTick) {
            buf.m_130130_(d.currentTick);
            buf.m_130130_(d.maxTick);
        } else {
            buf.writeFloat(d.ratio);
        }
        buf.m_130130_(d.input.size());
        for (ItemStack stack : d.input) {
            buf.m_130055_(stack);
        }
        buf.m_130130_(d.output.size());
        for (ItemStack stack : d.output) {
            buf.m_130055_(stack);
        }
    }

    public static ProgressDataImpl of(FriendlyByteBuf buf) {
        boolean hasTick = buf.readBoolean();
        ProgressDataImpl d = hasTick ? new ProgressDataImpl(buf.m_130242_(), buf.m_130242_()) : new ProgressDataImpl(buf.readFloat());
        int inputSize = buf.m_130242_();
        d.input.ensureCapacity(inputSize);
        for (int i = 0; i < inputSize; ++i) {
            d.input.add(buf.m_130267_());
        }
        int outputSize = buf.m_130242_();
        d.output.ensureCapacity(outputSize);
        for (int i = 0; i < outputSize; ++i) {
            d.output.add(buf.m_130267_());
        }
        return d;
    }

    public ProgressDataImpl(float ratio) {
        this.hasTick = false;
        this.ratio = ratio;
    }

    public ProgressDataImpl(int currentTick, int maxTick) {
        this.hasTick = true;
        this.currentTick = currentTick;
        this.maxTick = maxTick;
    }

    public ArrayList<ItemStack> input() {
        return this.input;
    }

    public ArrayList<ItemStack> output() {
        return this.output;
    }
}

