/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.plugin.vanilla.config.EnchantmentDisplayMode;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.jetbrains.annotations.Nullable;

public enum ItemEntityProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static final ResourceLocation AUTHOR;
    private static final ResourceLocation GENERATION;
    private static long lastEnchantmentTime;
    private static int enchantmentIndex;
    private static int curseIndex;

    @Override
    @Nullable
    public Entity getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return !config.getBoolean(Options.ENTITY_ITEM_ENTITY) ? EMPTY_ENTITY : null;
    }

    @Override
    public ITooltipComponent getIcon(IEntityAccessor accessor, IPluginConfig config) {
        return new ItemComponent(((ItemEntity)accessor.getEntity()).m_32055_());
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        ItemStack stack = ((ItemEntity)accessor.getEntity()).m_32055_();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(stack.m_41786_()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(Registry.f_122827_.m_7981_((Object)stack.m_41720_())));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        ItemStack stack = ((ItemEntity)accessor.getEntity()).m_32055_();
        ItemEntityProvider.appendBookProperties(tooltip, stack, config);
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            String mod = IModInfo.get(((ItemEntity)accessor.getEntity()).m_32055_()).getName();
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(mod));
        }
    }

    public static void appendBookProperties(ITooltip tooltip, ItemStack stack, IPluginConfig config) {
        if (stack.m_150930_(Items.f_42690_)) {
            EnchantmentDisplayMode mode = (EnchantmentDisplayMode)((Object)config.getEnum(Options.BOOK_ENCHANTMENT_DISPLAY_MODE));
            if (mode == EnchantmentDisplayMode.DISABLED) {
                return;
            }
            if (mode == EnchantmentDisplayMode.CYCLE) {
                EnchantmentInstance instance;
                int enchantmentTiming = config.getInt(Options.BOOK_ENCHANTMENT_CYCLE_TIMING);
                ListTag enchantmentsTag = EnchantedBookItem.m_41163_((ItemStack)stack);
                long now = System.currentTimeMillis();
                ArrayList<EnchantmentInstance> enchantments = new ArrayList<EnchantmentInstance>();
                ArrayList<EnchantmentInstance> curses = new ArrayList<EnchantmentInstance>();
                for (int i = 0; i < enchantmentsTag.size(); ++i) {
                    CompoundTag enchantmentTag = enchantmentsTag.m_128728_(i);
                    Enchantment enchantment = (Enchantment)Registry.f_122825_.m_7745_(EnchantmentHelper.m_182446_((CompoundTag)enchantmentTag));
                    if (enchantment == null) continue;
                    int level = EnchantmentHelper.m_182438_((CompoundTag)enchantmentTag);
                    EnchantmentInstance instance2 = new EnchantmentInstance(enchantment, level);
                    if (enchantment.m_6589_()) {
                        curses.add(instance2);
                        continue;
                    }
                    enchantments.add(instance2);
                }
                if (now - lastEnchantmentTime >= (long)enchantmentTiming) {
                    lastEnchantmentTime = now;
                    ++curseIndex;
                    if (++enchantmentIndex > enchantments.size() - 1) {
                        enchantmentIndex = 0;
                    }
                    if (curseIndex > curses.size() - 1) {
                        curseIndex = 0;
                    }
                }
                Object text = null;
                if (!enchantments.isEmpty()) {
                    instance = (EnchantmentInstance)enchantments.get(enchantmentIndex);
                    text = instance.f_44947_.m_44700_(instance.f_44948_);
                }
                if (!curses.isEmpty()) {
                    instance = (EnchantmentInstance)curses.get(curseIndex);
                    Component curse = instance.f_44947_.m_44700_(instance.f_44948_);
                    text = text == null ? curse : text.m_6881_().m_7220_(CommonComponents.f_178388_).m_7220_(curse);
                }
                if (text != null) {
                    tooltip.setLine(Options.BOOK_ENCHANTMENT_DISPLAY_MODE, (Component)text);
                }
            } else {
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                MutableComponent text = null;
                if (mode == EnchantmentDisplayMode.COMBINED) {
                    MutableComponent enchantmentLine = null;
                    MutableComponent curseLine = null;
                    for (Map.Entry entry : enchantments.entrySet()) {
                        Enchantment enchantment = (Enchantment)entry.getKey();
                        int level = (Integer)entry.getValue();
                        Component name = enchantment.m_44700_(level);
                        if (enchantment.m_6589_()) {
                            if (curseLine == null) {
                                curseLine = Component.m_237119_().m_7220_(name);
                                continue;
                            }
                            curseLine.m_7220_((Component)Component.m_237113_((String)", ")).m_7220_(name);
                            continue;
                        }
                        if (enchantmentLine == null) {
                            enchantmentLine = Component.m_237119_().m_7220_(name);
                            continue;
                        }
                        enchantmentLine.m_7220_((Component)Component.m_237113_((String)", ")).m_7220_(name);
                    }
                    if (enchantmentLine != null) {
                        text = enchantmentLine;
                    }
                    if (curseLine != null) {
                        if (text == null) {
                            text = curseLine;
                        } else {
                            text.m_7220_(CommonComponents.f_178388_).m_7220_(curseLine);
                        }
                    }
                } else {
                    for (Map.Entry entry : enchantments.entrySet()) {
                        Component name = ((Enchantment)entry.getKey()).m_44700_(((Integer)entry.getValue()).intValue());
                        if (text == null) {
                            text = Component.m_237119_().m_7220_(name);
                            continue;
                        }
                        text.m_7220_(CommonComponents.f_178388_).m_7220_(name);
                    }
                }
                if (text != null) {
                    tooltip.setLine(Options.BOOK_ENCHANTMENT_DISPLAY_MODE, (Component)text);
                }
            }
        } else if (stack.m_150930_(Items.f_42615_)) {
            if (!config.getBoolean(Options.BOOK_WRITTEN) || !stack.m_41782_()) {
                return;
            }
            CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
            String author = tag.m_128461_("author");
            int generation = WrittenBookItem.m_43473_((ItemStack)stack);
            if (!StringUtil.m_14408_((String)author)) {
                tooltip.setLine(AUTHOR, (Component)Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{author}));
            }
            tooltip.setLine(GENERATION, (Component)Component.m_237115_((String)("book.generation." + generation)));
        }
    }

    static {
        AUTHOR = Options.withSuffix(Options.BOOK_WRITTEN, ".author");
        GENERATION = Options.withSuffix(Options.BOOK_WRITTEN, ".generation");
        lastEnchantmentTime = 0L;
        enchantmentIndex = 0;
        curseIndex = 0;
    }
}

