/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.IntFunction;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.__internal__.IExtraService;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public abstract class ItemData
implements IData {
    public static final ResourceLocation ID = BuiltinDataUtil.rl("item");
    public static final IData.Type<ItemData> TYPE = IData.createType(ID);
    public static final ResourceLocation CONFIG_SYNC_NBT = BuiltinDataUtil.rl("item.nbt");
    public static final ResourceLocation CONFIG_DISPLAY_MODE = BuiltinDataUtil.rl("item.display_mode");
    public static final ResourceLocation CONFIG_MAX_HEIGHT = BuiltinDataUtil.rl("item.max_height");
    public static final ResourceLocation CONFIG_SORT_BY_COUNT = BuiltinDataUtil.rl("item.sort_by_count");
    public static final ResourceLocation CONFIG_GRID_MODE_SCALE = BuiltinDataUtil.rl("item.grid_mode_scale");
    protected final ArrayList<ItemStack> items = new ArrayList();

    public static ItemData of(IPluginConfig config) {
        return IExtraService.INSTANCE.createItemData(config);
    }

    public ItemData vanilla(Container container) {
        int size = container.getContainerSize();
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(container.getItem(i));
        }
        return this;
    }

    public ItemData getter(IntFunction<ItemStack> getter, int size) {
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(getter.apply(i));
        }
        return this;
    }

    public ItemData add(ItemStack stack) {
        this.items.add(stack);
        return this;
    }

    public ItemData add(ItemStack ... stacks) {
        this.ensureSpace(stacks.length);
        Collections.addAll(this.items, stacks);
        return this;
    }

    public ItemData add(Collection<ItemStack> stacks) {
        this.items.addAll(stacks);
        return this;
    }

    public ItemData ensureSpace(int length) {
        this.items.ensureCapacity(this.items.size() + length);
        return this;
    }

    public static enum ItemDisplayMode {
        GRID,
        LIST,
        DYNAMIC;

    }
}

