/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mcp.mobius.waila.gui.screen.CreditsScreen;
import mcp.mobius.waila.gui.screen.PluginConfigScreen;
import mcp.mobius.waila.gui.screen.PluginToggleScreen;
import mcp.mobius.waila.gui.screen.WailaConfigScreen;
import mcp.mobius.waila.mixin.TabNavigationBarAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public interface TabbedScreen {
    public static final Supplier<TabNavigationBar> TABS = () -> TabbedScreen.bar(new Tab<WailaConfigScreen>(WailaConfigScreen.TITLE, WailaConfigScreen.class, WailaConfigScreen::new), new Tab<PluginToggleScreen>(PluginToggleScreen.TITLE, PluginToggleScreen.class, PluginToggleScreen::new), new Tab<PluginConfigScreen>(PluginConfigScreen.TITLE, PluginConfigScreen.class, PluginConfigScreen::new), new Tab<CreditsScreen>(CreditsScreen.TITLE, CreditsScreen.class, CreditsScreen::new));

    public static TabNavigationBar bar(Tab<?> ... tabs) {
        return TabNavigationBar.builder((TabManager)new TabManager(t -> {}, t -> {}, t -> {
            Tab tab = (Tab)t;
            Minecraft client = Minecraft.getInstance();
            Screen parent = client.screen;
            if (parent != null && parent.getClass() == tab.clazz) {
                return;
            }
            if (parent instanceof TabbedScreen) {
                TabbedScreen tabbed = (TabbedScreen)parent;
                tabbed.changeTab(() -> client.setScreen((Screen)tab.ctor.apply(tabbed.getParent())));
            } else {
                client.setScreen((Screen)tab.ctor.apply(parent));
            }
        }, t -> {}), (int)tabs.length).addTabs((net.minecraft.client.gui.components.tabs.Tab[])tabs).build();
    }

    public Screen getParent();

    default public void changeTab(Runnable change) {
        change.run();
    }

    default public void initBar(int width, Consumer<TabNavigationBar> addRenderableWidget, Consumer<TabButton> setInitialFocus) {
        Class<?> clazz = this.getClass();
        TabNavigationBar tabs = TABS.get();
        Tab currentTab = tabs.getTabs().stream().map(it -> (Tab)it).filter(it -> it.clazz == clazz).findFirst().orElse(null);
        tabs.setWidth(width);
        tabs.arrangeElements();
        addRenderableWidget.accept(tabs);
        if (currentTab != null) {
            tabs.selectTab(tabs.getTabs().indexOf(currentTab), false);
            setInitialFocus.accept(((TabNavigationBarAccess)tabs).wthit_currentTabButton());
        }
    }

    public record Tab<T extends Screen>(Component title, Class<T> clazz, Function<Screen, T> ctor) implements net.minecraft.client.gui.components.tabs.Tab
    {
        public Component getTabTitle() {
            return this.title;
        }

        public Component getTabExtraNarration() {
            return Component.empty();
        }

        public void visitChildren(Consumer<AbstractWidget> consumer) {
        }

        public void doLayout(ScreenRectangle screenRectangle) {
        }
    }
}

