/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class CycleValue
extends ConfigValue<String, CycleValue> {
    private final Button button;
    private final boolean createLocale;
    private final List<String> values;

    public CycleValue(String optionName, String[] values, String selected, Consumer<String> save, boolean createLocale) {
        this(optionName, values, selected, null, save, createLocale);
    }

    public CycleValue(String optionName, String[] values, String selected, @Nullable String defaultValue, Consumer<String> save, boolean createLocale) {
        super(optionName, selected, defaultValue, save);
        this.createLocale = createLocale;
        this.values = (List)Util.make(new ArrayList(), list -> list.addAll(Arrays.asList(values)));
        this.button = DisplayUtil.createButton(0, 0, 100, 20, (Component)(createLocale ? Component.translatable((String)(optionName + "_" + selected.replace(" ", "_").toLowerCase(Locale.ROOT))) : Component.literal((String)selected)), w -> this.setValue(this.values.get((this.values.indexOf(this.getValue()) + 1) % this.values.size())));
    }

    public void addValue(String value) {
        if (!this.values.contains(value)) {
            this.values.add(value);
        }
    }

    public void removeValue(String value) {
        int index = this.values.indexOf(value);
        if (index > -1) {
            this.values.remove(index);
            this.setValue(this.values.get(index % this.values.size()));
        }
    }

    @Override
    protected void drawValue(GuiGraphics ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.button.active = !this.isDisabled();
        this.button.setX(x + width - this.button.getWidth());
        this.button.setY(y + (height - this.button.getHeight()) / 2);
        this.button.setMessage((Component)(this.createLocale ? Component.translatable((String)this.getValueTlKey()) : Component.literal((String)((String)this.getValue()))));
        this.button.render(ctx, mouseX, mouseY, partialTicks);
    }

    @Override
    public GuiEventListener getListener() {
        return this.button;
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        super.buildSearchKey(sb);
        sb.append(" ");
        if (this.createLocale) {
            sb.append(I18n.get((String)this.getValueTlKey(), (Object[])new Object[0]));
        } else {
            sb.append((String)this.getValue());
        }
    }

    private String getValueTlKey() {
        return this.translationKey + "_" + ((String)this.getValue()).replace(" ", "_").toLowerCase(Locale.ROOT);
    }
}

