/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IApiService;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@ApiSide.ClientOnly
public class NamedItemComponent
implements ITooltipComponent {
    public static final NamedItemComponent EMPTY = new NamedItemComponent(ItemStack.EMPTY);
    public final ItemStack stack;
    public final String label;

    public NamedItemComponent(ItemStack stack) {
        this.stack = stack;
        int count = stack.getCount();
        String name = stack.getHoverName().getString();
        this.label = count > 1 ? WailaHelper.suffix(count) + " " + name : name;
    }

    public NamedItemComponent(ItemLike item) {
        this(new ItemStack(item));
    }

    @Override
    public int getWidth() {
        return this.getFont().width(this.label) + 10;
    }

    @Override
    public int getHeight() {
        Objects.requireNonNull(this.getFont());
        return 9;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        PoseStack pose = ctx.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        pose.scale(0.5f, 0.5f, 0.5f);
        ctx.renderItem(this.stack, 0, 0);
        pose.popPose();
        ctx.drawString(this.getFont(), this.label, x + 10, y, IApiService.INSTANCE.getFontColor());
    }

    private Font getFont() {
        return Minecraft.getInstance().font;
    }
}

