/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import java.util.function.Supplier;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.command.ArgumentBuilderBuilder;
import mcp.mobius.waila.command.CommonCommand;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.mixin.BaseContainerBlockEntityAccess;
import mcp.mobius.waila.network.play.s2c.GenerateClientDumpPlayS2CPacket;
import mcp.mobius.waila.plugin.PluginLoader;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class ServerCommand
extends CommonCommand<CommandSourceStack, MinecraftServer> {
    public ServerCommand() {
        super("waila");
    }

    @Nullable
    protected abstract String fillContainer(ServerLevel var1, BlockPos var2, ServerPlayer var3);

    @Override
    protected boolean pluginCommandRequirement(CommandSourceStack source) {
        return source.hasPermission(3);
    }

    @Override
    protected void register(ArgumentBuilderBuilder<CommandSourceStack> command) {
        command.then((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)"dump")).requires(source -> source.hasPermission(3)).executes((Command<CommandSourceStack>)((Command)context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            MinecraftServer server = source.getServer();
            boolean dedicated = server.isDedicatedServer();
            Path path = DumpGenerator.generate(dedicated ? "server_dump" : "local_dump");
            if (path != null) {
                ServerPlayer player;
                MutableComponent pathComponent = Component.literal((String)path.toString()).withStyle(style -> style.withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, path.toString())));
                source.sendSuccess(() -> ServerCommand.lambda$register$2(dedicated, (Component)pathComponent), false);
                Entity entity = source.getEntity();
                if (entity instanceof ServerPlayer && !server.isSingleplayerOwner((player = (ServerPlayer)entity).getGameProfile())) {
                    PacketSender.s2c((ServerPlayer)player).send((CustomPacketPayload)GenerateClientDumpPlayS2CPacket.PAYLOAD);
                }
                return 1;
            }
            return 0;
        })).pop("dump");
        if (Waila.ENABLE_DEBUG_COMMAND) {
            command.then((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)"debug")).requires(source -> source.hasPermission(3)).then((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)"getBlockInfo")).then((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos())).executes((Command<CommandSourceStack>)((Command)context -> {
                CommandSourceStack source = (CommandSourceStack)context.getSource();
                ServerLevel world = source.getLevel();
                BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos");
                Block block = world.getBlockState(pos).getBlock();
                source.sendSuccess(() -> Component.literal((String)("Block ID: " + String.valueOf(block.builtInRegistryHolder().key().location()))), false);
                source.sendSuccess(() -> Component.literal((String)("Block class: " + block.getClass().getName())), false);
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity != null) {
                    source.sendSuccess(() -> Component.literal((String)("Block entity type ID: " + String.valueOf(blockEntity.getType().builtInRegistryHolder().key().location()))), false);
                    source.sendSuccess(() -> Component.literal((String)("Block entity class: " + blockEntity.getClass().getName())), false);
                }
                return 1;
            })).pop("pos", "getBlockInfo").then((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)"getEntityInfo")).then((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument((String)"target", (ArgumentType)EntityArgument.entity())).executes((Command<CommandSourceStack>)((Command)context -> {
                CommandSourceStack source = (CommandSourceStack)context.getSource();
                Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"target");
                source.sendSuccess(() -> Component.literal((String)("Entity type ID: " + String.valueOf(entity.getType().builtInRegistryHolder().key().location()))), false);
                source.sendSuccess(() -> Component.literal((String)("Entity class: " + entity.getClass().getName())), false);
                return 1;
            })).pop("target", "getEntityInfo").then((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)"lockContainer")).then((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos())).then((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument((String)"lock", (ArgumentType)StringArgumentType.string())).executes((Command<CommandSourceStack>)((Command)context -> {
                CommandSourceStack source = (CommandSourceStack)context.getSource();
                ServerLevel world = source.getLevel();
                ServerPlayer player = source.getPlayer();
                BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos");
                String lock = StringArgumentType.getString((CommandContext)context, (String)"lock");
                if (player == null) {
                    source.sendFailure((Component)Component.literal((String)"Needs a player"));
                } else {
                    BlockEntity patt0$temp = world.getBlockEntity(pos);
                    if (patt0$temp instanceof BaseContainerBlockEntityAccess) {
                        BaseContainerBlockEntityAccess container = (BaseContainerBlockEntityAccess)patt0$temp;
                        container.wthit_lockKey(new LockCode(lock));
                        ItemStack key = new ItemStack((ItemLike)Items.NAME_TAG);
                        key.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)lock));
                        player.setItemInHand(InteractionHand.MAIN_HAND, key);
                        source.sendSuccess(() -> Component.literal((String)("Locked container " + pos.toShortString() + " with lock \"" + lock + "\"")), false);
                        return 1;
                    }
                    source.sendFailure((Component)Component.literal((String)("Couldn't lock container " + pos.toShortString())));
                }
                return 0;
            })).pop("lock", "pos", "lockContainer").then((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)"fillContainer")).then((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos())).executes((Command<CommandSourceStack>)((Command)context -> {
                CommandSourceStack source = (CommandSourceStack)context.getSource();
                ServerLevel world = source.getLevel();
                ServerPlayer player = source.getPlayer();
                BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos");
                String err = this.fillContainer(world, pos, player);
                if (err != null) {
                    source.sendFailure((Component)Component.literal((String)err));
                    return 0;
                }
                source.sendSuccess(() -> Component.literal((String)("Filled " + pos.toShortString())), false);
                return 1;
            })).pop("pos", "fillContainer").pop("debug");
        }
    }

    @Override
    protected LiteralArgumentBuilder<CommandSourceStack> literal(String name) {
        return Commands.literal((String)name);
    }

    @Override
    protected <T> RequiredArgumentBuilder<CommandSourceStack, T> argument(String name, ArgumentType<T> type) {
        return Commands.argument((String)name, type);
    }

    @Override
    protected void success(CommandSourceStack source, Supplier<Component> msg) {
        source.sendSuccess(msg, false);
    }

    @Override
    protected void fail(CommandSourceStack source, Component msg) {
        source.sendFailure(msg);
    }

    @Override
    protected MinecraftServer getExecutor(CommandSourceStack source) {
        return source.getServer();
    }

    @Override
    protected void reloadPlugins(MinecraftServer executor) {
        PluginLoader.reloadServerPlugins(executor);
    }

    private static /* synthetic */ Component lambda$register$2(boolean dedicated, Component pathComponent) {
        return Component.translatable((String)(dedicated ? "command.waila.server_dump_success" : "command.waila.local_dump_success"), (Object[])new Object[]{pathComponent});
    }
}

