/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IllegalFormatException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;

public final class DisplayUtil {
    private static final Minecraft CLIENT = Minecraft.getInstance();

    public static void enable3DRender() {
        Lighting.setupFor3DItems();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        Lighting.setupForFlatItems();
        RenderSystem.disableDepthTest();
    }

    public static void renderRectBorder(Matrix4f matrix, VertexConsumer buf, int x, int y, int w, int h, int s, int gradStart, int gradEnd) {
        if (s <= 0) {
            return;
        }
        DisplayUtil.fillGradient(matrix, buf, x, y, w, s, gradStart, gradStart);
        DisplayUtil.fillGradient(matrix, buf, x, y + h - s, w, s, gradEnd, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x, y + s, s, h - s * 2, gradStart, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x + w - s, y + s, s, h - s * 2, gradStart, gradEnd);
    }

    public static void fillGradient(Matrix4f matrix, VertexConsumer buf, int x, int y, int w, int h, int start, int end) {
        float sa = (float)FastColor.ARGB32.alpha((int)start) / 255.0f;
        float sr = (float)FastColor.ARGB32.red((int)start) / 255.0f;
        float sg = (float)FastColor.ARGB32.green((int)start) / 255.0f;
        float sb = (float)FastColor.ARGB32.blue((int)start) / 255.0f;
        float ea = (float)FastColor.ARGB32.alpha((int)end) / 255.0f;
        float er = (float)FastColor.ARGB32.red((int)end) / 255.0f;
        float eg = (float)FastColor.ARGB32.green((int)end) / 255.0f;
        float eb = (float)FastColor.ARGB32.blue((int)end) / 255.0f;
        buf.addVertex(matrix, (float)x, (float)y, 0.0f).setColor(sr, sg, sb, sa);
        buf.addVertex(matrix, (float)x, (float)(y + h), 0.0f).setColor(er, eg, eb, ea);
        buf.addVertex(matrix, (float)(x + w), (float)(y + h), 0.0f).setColor(er, eg, eb, ea);
        buf.addVertex(matrix, (float)(x + w), (float)y, 0.0f).setColor(sr, sg, sb, sa);
    }

    public static int getAlphaFromPercentage(int percentage) {
        return percentage == 100 ? -16777216 : (percentage == 0 ? 0x1000000 : (int)((float)percentage / 100.0f * 256.0f) << 24);
    }

    public static String tryFormat(String format, Object ... args) {
        try {
            return format.formatted(args);
        }
        catch (IllegalFormatException e) {
            return "FORMATTING ERROR";
        }
    }

    public static Button createButton(int x, int y, int width, int height, Component label, Button.OnPress pressAction) {
        return Button.builder((Component)label, (Button.OnPress)pressAction).bounds(x, y, width, height).build();
    }
}

