/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.component.BarComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class SpriteBarComponent
implements ITooltipComponent {
    private final float ratio;
    private final ResourceLocation texture;
    private final float u0;
    private final float u1;
    private final float v0;
    private final float v1;
    private final int spriteTint;
    private final int regionWidth;
    private final int regionHeight;
    private final Component text;

    public SpriteBarComponent(float ratio, ResourceLocation texture, float u0, float u1, float v0, float v1, int regionWidth, int regionHeight, int tint, Component text) {
        this.ratio = ratio;
        this.texture = texture;
        this.u0 = u0;
        this.u1 = u1;
        this.v0 = v0;
        this.v1 = v1;
        this.spriteTint = tint;
        this.regionWidth = regionWidth;
        this.regionHeight = regionHeight;
        this.text = text;
    }

    public SpriteBarComponent(float ratio, TextureAtlasSprite sprite, int regionWidth, int regionHeight, int tint, Component text) {
        this(ratio, sprite.m_247685_(), sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), regionWidth, regionHeight, tint, text);
    }

    @Override
    public int getWidth() {
        return Math.max(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.text), 100);
    }

    @Override
    public int getHeight() {
        return 11;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, float delta) {
        PoseStack matrices = ctx.m_280168_();
        BarComponent.renderBar(matrices, x, y, 100.0f, 0.0f, 0.4765625f, 0.04296875f, -5592406);
        matrices.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int mx = (int)((float)x + 100.0f * this.ratio);
        int my = y + 11;
        ctx.m_280588_(x + 1, y + 1, mx - 1, my - 1);
        int a = WailaHelper.getAlpha(this.spriteTint);
        int r = WailaHelper.getRed(this.spriteTint);
        int g = WailaHelper.getGreen(this.spriteTint);
        int b = WailaHelper.getBlue(this.spriteTint);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        for (int px1 = x; px1 < mx; px1 += this.regionWidth) {
            int px2 = px1 + this.regionWidth;
            for (int py1 = y; py1 < my; py1 += this.regionHeight) {
                int py2 = py1 + this.regionHeight;
                buffer.m_252986_(matrices.m_85850_().m_252922_(), (float)px1, (float)py2, 0.0f).m_6122_(r, g, b, a).m_7421_(this.u0, this.v1).m_5752_();
                buffer.m_252986_(matrices.m_85850_().m_252922_(), (float)px2, (float)py2, 0.0f).m_6122_(r, g, b, a).m_7421_(this.u1, this.v1).m_5752_();
                buffer.m_252986_(matrices.m_85850_().m_252922_(), (float)px2, (float)py1, 0.0f).m_6122_(r, g, b, a).m_7421_(this.u1, this.v0).m_5752_();
                buffer.m_252986_(matrices.m_85850_().m_252922_(), (float)px1, (float)py1, 0.0f).m_6122_(r, g, b, a).m_7421_(this.u0, this.v0).m_5752_();
            }
        }
        tessellator.m_85914_();
        RenderSystem.disableBlend();
        matrices.m_85849_();
        ctx.m_280618_();
        BarComponent.renderText(matrices, this.text, x, y);
    }
}

