/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.gui.screen.TabbedScreen;
import mcp.mobius.waila.gui.screen.YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;

public class CreditsScreen
extends YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen
implements TabbedScreen {
    public static final Component TITLE = Component.m_237115_((String)"gui.waila.credits");
    private final Screen parent;

    protected CreditsScreen(Screen parent) {
        super(TITLE);
        this.parent = parent;
    }

    @Override
    public Screen getParent() {
        return this.parent;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initBar(this.f_96543_, x$0 -> {
            TabNavigationBar cfr_ignored_0 = (TabNavigationBar)this.m_142416_((GuiEventListener)x$0);
        }, x$0 -> this.m_264313_((GuiEventListener)x$0));
        try {
            CreditMap credits = (CreditMap)new Gson().fromJson((Reader)((Resource)this.minecraft.m_91098_().m_213713_(Waila.id("credits.json")).orElseThrow()).m_215508_(), CreditMap.class);
            Objects.requireNonNull(this.minecraft.f_91062_);
            ListWidget listWidget = new ListWidget(this.minecraft, this.f_96543_, this.f_96544_, 24, this.f_96544_ - 32, 9 + 6);
            credits.forEach((key, category) -> {
                List children = listWidget.m_6702_();
                children.add(new CreditLine(1, List.of(Component.m_237115_((String)("gui.waila.credits." + key)).m_130940_(ChatFormatting.GRAY))));
                for (List chunk : Lists.partition(category.values.stream().map(Component::m_237113_).toList(), (int)category.width)) {
                    children.add(new CreditLine(category.width, chunk));
                }
                children.add(new CreditLine(1, List.of()));
            });
            listWidget.init();
            this.m_142416_((GuiEventListener)listWidget);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_142416_((GuiEventListener)DisplayUtil.createButton(this.f_96543_ / 2 - 50, this.f_96544_ - 25, 100, 20, CommonComponents.f_130655_, w -> this.m_7379_()));
    }

    public void m_88315_(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(ctx);
        super.m_88315_(ctx, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        this.minecraft.m_91152_(this.parent);
    }

    private static class CreditMap
    extends LinkedHashMap<String, CreditCategory> {
        private CreditMap() {
        }
    }

    private static class ListWidget
    extends ContainerObjectSelectionList<CreditLine> {
        private ListWidget(Minecraft client, int width, int height, int top, int bottom, int itemHeight) {
            super(client, width, height, top, bottom, itemHeight);
        }

        private void init() {
            this.m_93488_(false);
            this.m_93496_(false);
            int totalHeight = (this.m_6702_().size() - 1) * this.f_93387_;
            if (totalHeight < this.f_93389_) {
                this.m_93473_(true, (this.f_93389_ - totalHeight) / 2 - this.f_93390_);
            }
        }

        public int m_5759_() {
            return Math.min(this.f_93388_ - 20, 360);
        }

        protected int m_5756_() {
            return this.f_93386_.m_91268_().m_85445_() - 5;
        }

        protected void m_7154_(GuiGraphics ctx, int mouseX, int mouseY) {
            ctx.m_285978_(RenderType.m_286086_(), this.f_93393_, this.f_93391_ - 4, this.f_93392_, this.f_93391_, 0, -16777216, 0);
        }
    }

    private class CreditLine
    extends ContainerObjectSelectionList.Entry<CreditLine> {
        private final int column;
        private final List<MutableComponent> components;

        private CreditLine(int column, List<MutableComponent> components) {
            this.column = column;
            this.components = components;
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public void m_6311_(@NotNull GuiGraphics ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            if (this.components.isEmpty()) {
                return;
            }
            int columnWidth = width / this.column;
            for (int i = 0; i < this.components.size(); ++i) {
                MutableComponent component = this.components.get(i);
                ctx.m_280653_(CreditsScreen.this.minecraft.f_91062_, (Component)component, rowLeft + columnWidth * i + columnWidth / 2, rowTop + 3, 0xFFFFFF);
            }
        }
    }

    private static class CreditCategory {
        int width = 0;
        List<String> values = List.of();

        private CreditCategory() {
        }
    }
}

