/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import com.mojang.authlib.GameProfile;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public enum PlayerHeadProvider implements IBlockComponentProvider
{
    INSTANCE;

    static final ItemStack PLAYER_HEAD_STACK;

    @Override
    @Nullable
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        SkullBlockEntity skull = (SkullBlockEntity)accessor.getBlockEntity();
        if (skull != null && skull.m_59779_() != null) {
            CompoundTag tag = PLAYER_HEAD_STACK.m_41784_();
            CompoundTag skullOwner = tag.m_128469_("SkullOwner");
            tag.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)skullOwner, (GameProfile)skull.m_59779_()));
            return new ItemComponent(PLAYER_HEAD_STACK);
        }
        return null;
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        SkullBlockEntity skull = (SkullBlockEntity)accessor.getBlockEntity();
        if (skull == null) {
            return;
        }
        GameProfile profile = skull.m_59779_();
        if (profile == null) {
            return;
        }
        String name = profile.getName();
        if (name == null || StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, IWailaConfig.get().getFormatter().blockName(I18n.m_118938_((String)"block.minecraft.player_head.named", (Object[])new Object[]{name})));
    }

    static {
        PLAYER_HEAD_STACK = new ItemStack((ItemLike)Items.f_42680_);
    }
}

