/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IllegalFormatException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;

public final class DisplayUtil {
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public static void enable3DRender() {
        Lighting.m_84931_();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        Lighting.m_84930_();
        RenderSystem.disableDepthTest();
    }

    public static void renderRectBorder(Matrix4f matrix, VertexConsumer buf, int x, int y, int w, int h, int s, int gradStart, int gradEnd) {
        if (s <= 0) {
            return;
        }
        DisplayUtil.fillGradient(matrix, buf, x, y, w, s, gradStart, gradStart);
        DisplayUtil.fillGradient(matrix, buf, x, y + h - s, w, s, gradEnd, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x, y + s, s, h - s * 2, gradStart, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x + w - s, y + s, s, h - s * 2, gradStart, gradEnd);
    }

    public static void fillGradient(Matrix4f matrix, VertexConsumer buf, int x, int y, int w, int h, int start, int end) {
        float sa = (float)FastColor.ARGB32.m_13655_((int)start) / 255.0f;
        float sr = (float)FastColor.ARGB32.m_13665_((int)start) / 255.0f;
        float sg = (float)FastColor.ARGB32.m_13667_((int)start) / 255.0f;
        float sb = (float)FastColor.ARGB32.m_13669_((int)start) / 255.0f;
        float ea = (float)FastColor.ARGB32.m_13655_((int)end) / 255.0f;
        float er = (float)FastColor.ARGB32.m_13665_((int)end) / 255.0f;
        float eg = (float)FastColor.ARGB32.m_13667_((int)end) / 255.0f;
        float eb = (float)FastColor.ARGB32.m_13669_((int)end) / 255.0f;
        buf.m_252986_(matrix, (float)x, (float)y, 0.0f).m_85950_(sr, sg, sb, sa).m_5752_();
        buf.m_252986_(matrix, (float)x, (float)(y + h), 0.0f).m_85950_(er, eg, eb, ea).m_5752_();
        buf.m_252986_(matrix, (float)(x + w), (float)(y + h), 0.0f).m_85950_(er, eg, eb, ea).m_5752_();
        buf.m_252986_(matrix, (float)(x + w), (float)y, 0.0f).m_85950_(sr, sg, sb, sa).m_5752_();
    }

    public static int getAlphaFromPercentage(int percentage) {
        return percentage == 100 ? -16777216 : (percentage == 0 ? 0x1000000 : (int)((float)percentage / 100.0f * 256.0f) << 24);
    }

    public static String tryFormat(String format, Object ... args) {
        try {
            return format.formatted(args);
        }
        catch (IllegalFormatException e) {
            return "FORMATTING ERROR";
        }
    }

    public static Button createButton(int x, int y, int width, int height, Component label, Button.OnPress pressAction) {
        return Button.m_253074_((Component)label, (Button.OnPress)pressAction).m_252987_(x, y, width, height).m_253136_();
    }
}

