/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import java.util.Locale;
import java.util.function.Consumer;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumValue<T extends Enum<T>>
extends ConfigValue<T, EnumValue<T>> {
    private final Button button;

    public EnumValue(String optionName, T[] values, T selected, @Nullable T defaultValue, Consumer<T> save) {
        super(optionName, selected, defaultValue, save);
        this.button = DisplayUtil.createButton(0, 0, 100, 20, (Component)Component.m_237115_((String)(optionName + "_" + ((Enum)selected).name().toLowerCase(Locale.ROOT))), button -> {
            this.setValue(values[(((Enum)this.getValue()).ordinal() + 1) % values.length]);
            button.m_93666_((Component)Component.m_237115_((String)this.getValueTlKey()));
        });
    }

    @Override
    protected void drawValue(GuiGraphics ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.button.f_93623_ = !this.isDisabled();
        this.button.m_252865_(x + width - this.button.m_5711_());
        this.button.m_253211_(y + (height - this.button.m_93694_()) / 2);
        this.button.m_88315_(ctx, mouseX, mouseY, partialTicks);
    }

    @NotNull
    public Button getListener() {
        return this.button;
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        super.buildSearchKey(sb);
        sb.append(" ").append(I18n.m_118938_((String)this.getValueTlKey(), (Object[])new Object[0]));
    }

    private String getValueTlKey() {
        return this.translationKey + "_" + ((Enum)this.getValue()).name().toLowerCase(Locale.ROOT);
    }
}

