/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.hud.theme.ThemeAccessor;
import mcp.mobius.waila.gui.hud.theme.ThemeDefinition;
import mcp.mobius.waila.gui.hud.theme.ThemeType;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.screen.WailaConfigScreen;
import mcp.mobius.waila.gui.widget.ButtonEntry;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.BooleanValue;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.gui.widget.value.CycleValue;
import mcp.mobius.waila.gui.widget.value.EnumValue;
import mcp.mobius.waila.gui.widget.value.InputValue;
import mcp.mobius.waila.gui.widget.value.IntInputValue;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.TypeUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5244;

class ThemeEditorScreen
extends ConfigScreen {
    private final WailaConfigScreen parent;
    private final ThemeDefinition<?> template;
    private final boolean edit;
    private final TooltipRenderer.State previewState;
    private ThemeType<?> type;
    private ITheme theme;
    private ConfigListWidget options;
    private CategoryEntry themeAttrCategory;
    private ButtonEntry refreshButton;
    private InputValue<String> idVal;
    private CycleValue typeVal;
    private final Map<ThemeType<?>, Map<String, Object>> type2attr = new HashMap();
    private final Map<String, ConfigValue<Object>> attrValues = new HashMap<String, ConfigValue<Object>>();

    public ThemeEditorScreen(WailaConfigScreen parent, ThemeDefinition<?> template, boolean edit) {
        super(parent, class_5244.field_39003, () -> {}, () -> {});
        this.parent = parent;
        this.template = template;
        this.edit = edit;
        this.previewState = new PreviewTooltipRendererState();
        this.type = template.type;
        this.type2attr.put(this.type, new HashMap(this.type.properties.size()));
        this.type.properties.forEach((key, prop) -> this.type2attr.get(this.type).put((String)key, prop.get(template.instance)));
        this.buildTheme();
    }

    private void buildTheme() {
        this.theme = this.type.create(this.type2attr.get(this.type));
        this.theme.processProperties(ThemeAccessor.INSTANCE);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.parent.buildPreview(this.previewState);
    }

    @Override
    public ConfigListWidget getOptions() {
        this.options = new ConfigListWidget(this, this.minecraft, this.field_22789, this.field_22790, this.parent.buildPreview((TooltipRenderer.State)this.previewState).height * 2 + 4, this.field_22790 - 32, 26, () -> {});
        if (this.idVal == null) {
            this.idVal = new InputValue<String>("config.waila.overlay_theme_editor.id", this.edit ? this.template.id.toString() : "", null, val -> {}, InputValue.IDENTIFIER);
        }
        if (this.edit) {
            this.idVal.disable(null);
        }
        if (this.typeVal == null) {
            this.typeVal = new CycleValue("config.waila.overlay_theme_editor.type", (String[])Registrar.get().themeTypes.keySet().stream().map(class_2960::toString).sorted(String::compareToIgnoreCase).toArray(String[]::new), this.type.getId().toString(), val -> {}, false){

                @Override
                public void setValue(String value) {
                    if (ThemeEditorScreen.this.options.save(true)) {
                        super.setValue(value);
                        ThemeEditorScreen.this.type = (ThemeType)Registrar.get().themeTypes.get((Object)class_2960.method_60654((String)value));
                        ThemeEditorScreen.this.themeAttrCategory.clear(ThemeEditorScreen.this.options);
                        ThemeEditorScreen.this.options.method_25396().remove((Object)ThemeEditorScreen.this.themeAttrCategory);
                        ThemeEditorScreen.this.addTypeProperties(ThemeEditorScreen.this.options);
                        ThemeEditorScreen.this.options.init();
                        ThemeEditorScreen.this.options.method_25395((class_364)this);
                        this.method_25395(this.getListener());
                    }
                }
            };
        }
        this.refreshButton = new ButtonEntry("config.waila.overlay_theme_editor.refresh", 100, 20, button -> {
            if (this.options.save(false)) {
                this.buildTheme();
                this.options.resize(this.parent.buildPreview((TooltipRenderer.State)this.previewState).height * 2 + 4, this.field_22790 - 32);
                this.options.init();
                this.type.properties.forEach((key, prop) -> this.attrValues.get(key).setValue(prop.get(this.theme)));
                this.options.method_25395((class_364)this.refreshButton);
                this.refreshButton.method_25395((class_364)button);
            }
        });
        this.options.with(this.refreshButton).with(this.idVal).with(this.typeVal);
        if (this.edit) {
            this.options.with(new CategoryEntry("config.waila.overlay_theme_editor.delete").with(new ButtonEntry("config.waila.overlay_theme_editor.delete", 100, 20, button -> this.minecraft.method_1507((class_437)new class_410(delete -> {
                if (delete) {
                    this.parent.removeTheme(this.template.id);
                    this.minecraft.method_1507((class_437)this.parent);
                } else {
                    this.minecraft.method_1507((class_437)this);
                }
            }, (class_2561)class_2561.method_43469((String)"config.waila.overlay_theme_editor.delete_prompt", (Object[])new Object[]{this.template.id}), class_5244.field_39003)))));
        }
        this.addTypeProperties(this.options);
        this.options.enableSearchBox = false;
        return this.options;
    }

    private void addTypeProperties(ConfigListWidget options) {
        this.themeAttrCategory = new CategoryEntry("config.waila.overlay_theme_editor.attributes");
        options.add(options.method_25396().size() - (this.edit ? 2 : 0), this.themeAttrCategory);
        this.attrValues.clear();
        this.type2attr.computeIfAbsent(this.type, t -> new HashMap(t.properties.size()));
        this.type.properties.forEach((key, prop) -> {
            ConfigValue value;
            Class propType = prop.type;
            Map<String, Object> attr = this.type2attr.get(this.type);
            Object templateValue = attr.computeIfAbsent((String)key, k -> prop.defaultValue);
            if (propType == Integer.TYPE) {
                value = new IntInputValue(prop.getTlKey(), (Integer)TypeUtil.uncheckedCast(templateValue), null, val -> attr.put((String)key, val), (IntFormat)TypeUtil.uncheckedCast(prop.context));
            } else if (propType == Boolean.TYPE) {
                value = new BooleanValue(prop.getTlKey(), (Boolean)TypeUtil.uncheckedCast(templateValue), null, val -> attr.put((String)key, val));
            } else if (propType == Double.TYPE) {
                value = new InputValue<Object>(prop.getTlKey(), TypeUtil.uncheckedCast(templateValue), null, val -> attr.put((String)key, val), InputValue.DECIMAL);
            } else if (propType == String.class) {
                value = new InputValue<Object>(prop.getTlKey(), TypeUtil.uncheckedCast(templateValue), null, val -> attr.put((String)key, val), InputValue.ANY);
            } else if (propType.isEnum()) {
                value = new EnumValue(prop.getTlKey(), (Enum[])TypeUtil.uncheckedCast(propType.getEnumConstants()), (Enum)TypeUtil.uncheckedCast(templateValue), null, val -> attr.put((String)key, val));
            } else {
                throw new IllegalArgumentException("Invalid property type " + propType.getSimpleName());
            }
            value.setId((String)key);
            this.attrValues.put((String)key, (ConfigValue)((Object)((Object)TypeUtil.uncheckedCast((Object)value))));
            this.themeAttrCategory.with(value);
        });
    }

    @Override
    protected void renderForeground(class_332 ctx, int rowLeft, int rowWidth, int mouseX, int mouseY, float partialTicks) {
        TooltipRenderer.render(ctx, this.minecraft.method_61966());
    }

    @Override
    public void method_25419() {
        if (this.cancelled) {
            TooltipRenderer.resetState();
            super.method_25419();
            return;
        }
        if (((String)this.idVal.getValue()).isBlank()) {
            this.minecraft.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47587, (class_2561)class_2561.method_43471((String)"config.waila.missing_input"), (class_2561)class_2561.method_43471((String)"config.waila.overlay_theme_editor.id_empty")));
        } else {
            class_2960 id = class_2960.method_60654((String)((String)this.idVal.getValue()));
            if (id.method_12836().equals("minecraft") && !((String)this.idVal.getValue()).startsWith("minecraft:")) {
                id = class_2960.method_60655((String)"custom", (String)id.method_12832());
            }
            this.parent.addTheme(new ThemeDefinition(id, this.type, false, this.type2attr.get(this.type)));
            TooltipRenderer.resetState();
            super.method_25419();
        }
    }

    private class PreviewTooltipRendererState
    implements TooltipRenderer.State {
        private PreviewTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return true;
        }

        @Override
        public boolean fireEvent() {
            return false;
        }

        @Override
        public int getFps() {
            return 0;
        }

        @Override
        public float getScale() {
            return 2.0f;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return IWailaConfig.Overlay.Position.Align.Y.TOP;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return IWailaConfig.Overlay.Position.Align.Y.TOP;
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 1;
        }

        @Override
        public boolean bossBarsOverlap() {
            return false;
        }

        @Override
        public int getBackgroundAlpha() {
            return 255;
        }

        @Override
        public ITheme getTheme() {
            return ThemeEditorScreen.this.theme;
        }

        @Override
        public boolean enableTextToSpeech() {
            return false;
        }
    }
}

