/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.hud.theme.ThemeDefinition;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.screen.ThemeEditorScreen;
import mcp.mobius.waila.gui.widget.ButtonEntry;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.BooleanValue;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.gui.widget.value.CycleValue;
import mcp.mobius.waila.gui.widget.value.EnumValue;
import mcp.mobius.waila.gui.widget.value.InputValue;
import mcp.mobius.waila.mixin.KeyMappingAccess;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WailaConfigScreen
extends ConfigScreen {
    private static final class_2561 PREVIEW_PROMPT = class_2561.method_43471((String)"config.waila.preview_prompt");
    private final WailaConfig defaultConfig = new WailaConfig();
    private final TooltipRenderer.State previewState = new PreviewTooltipRendererState();
    @Nullable
    private ThemeDefinition<?> theme;
    private boolean f1held = false;
    private ConfigValue<String> modNameFormatVal;
    private ConfigValue<String> blockNameFormatVal;
    private ConfigValue<Integer> fpsVal;
    private ConfigValue<Integer> xPosValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.X> xAnchorValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.Y> yAnchorValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.X> xAlignValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.Y> yAlignValue;
    private ConfigValue<Integer> yPosValue;
    private ConfigValue<Float> scaleValue;
    private ConfigValue<Integer> backgroundAlphaVal;
    private ThemeValue themeIdVal;
    @Nullable
    private KeyBindValue selectedKeyBind;

    public WailaConfigScreen(class_437 parent) {
        super(parent, (class_2561)class_2561.method_43469((String)"gui.waila.configuration", (Object[])new Object[]{"WTHIT"}), Waila.CONFIG::save, Waila.CONFIG::invalidate);
    }

    private static WailaConfig get() {
        return Waila.CONFIG.get();
    }

    public Rectangle buildPreview(TooltipRenderer.State state) {
        TooltipRenderer.beginBuild(state);
        TooltipRenderer.setIcon(new ItemComponent((class_1935)class_2246.field_10219));
        TooltipRenderer.add(new Line(null).with((class_2561)class_2561.method_43470((String)DisplayUtil.tryFormat(this.blockNameFormatVal.getValue(), class_2246.field_10219.method_9518().getString()))));
        TooltipRenderer.add(new Line(null).with((class_2561)class_2561.method_43470((String)"never gonna give you up").method_27692(class_124.field_1051)));
        TooltipRenderer.add(new Line(null).with((class_2561)class_2561.method_43470((String)DisplayUtil.tryFormat(this.modNameFormatVal.getValue(), IModInfo.get(class_2246.field_10219).getName()))));
        return TooltipRenderer.endBuild();
    }

    public void addTheme(ThemeDefinition<?> theme) {
        WailaConfigScreen.get().getOverlay().getColor().getCustomThemes().put(theme.id, theme);
        ThemeDefinition.resetAll();
        String id = theme.id.toString();
        this.themeIdVal.addValue(id);
        this.themeIdVal.setValue(id);
        this.theme = theme;
    }

    public void removeTheme(class_2960 id) {
        WailaConfigScreen.get().getOverlay().getColor().getCustomThemes().remove(id);
        ThemeDefinition.resetAll();
        this.themeIdVal.removeValue(id.toString());
        this.theme = null;
    }

    private ThemeDefinition<?> getTheme() {
        if (this.theme == null) {
            this.theme = ThemeDefinition.getAll().get(class_2960.method_60654((String)((String)this.themeIdVal.getValue())));
        }
        return this.theme;
    }

    @Override
    public void method_25394(@NotNull class_332 ctx, int mouseX, int mouseY, float partialTicks) {
        if (class_3675.method_15987((long)this.minecraft.method_22683().method_4490(), (int)290)) {
            if (!this.f1held) {
                this.f1held = true;
                this.buildPreview(this.previewState);
            }
            this.method_25420(ctx, mouseX, mouseY, partialTicks);
            TooltipRenderer.render(ctx, this.minecraft.method_61966());
        } else {
            TooltipRenderer.resetState();
            this.f1held = false;
            this.theme = null;
            super.method_25394(ctx, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void renderForeground(class_332 ctx, int rowLeft, int rowWidth, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(ctx, rowLeft, rowWidth, mouseX, mouseY, partialTicks);
        ctx.method_27535(this.field_22793, PREVIEW_PROMPT, rowLeft, 22, 0xAAAAAA);
    }

    @Override
    public ConfigListWidget getOptions() {
        ConfigListWidget options = new ConfigListWidget(this, this.minecraft, this.field_22789, this.field_22790, 42, this.field_22790 - 32, 26, Waila.CONFIG::save);
        options.with(new CategoryEntry("config.waila.general").with(new BooleanValue("config.waila.display_tooltip", WailaConfigScreen.get().getGeneral().isDisplayTooltip(), this.defaultConfig.getGeneral().isDisplayTooltip(), val -> WailaConfigScreen.get().getGeneral().setDisplayTooltip((boolean)val))).with(new BooleanValue("config.waila.sneaky_details", WailaConfigScreen.get().getGeneral().isShiftForDetails(), this.defaultConfig.getGeneral().isShiftForDetails(), val -> WailaConfigScreen.get().getGeneral().setShiftForDetails((boolean)val))).with(new BooleanValue("config.waila.hide_sneak_text", WailaConfigScreen.get().getGeneral().isHideShiftText(), this.defaultConfig.getGeneral().isHideShiftText(), val -> WailaConfigScreen.get().getGeneral().setHideShiftText((boolean)val))).with(new EnumValue("config.waila.display_mode", (Enum[])IWailaConfig.General.DisplayMode.values(), (Enum)WailaConfigScreen.get().getGeneral().getDisplayMode(), (Enum)this.defaultConfig.getGeneral().getDisplayMode(), val -> WailaConfigScreen.get().getGeneral().setDisplayMode((IWailaConfig.General.DisplayMode)((Object)val)))).with(new BooleanValue("config.waila.hide_from_players", WailaConfigScreen.get().getGeneral().isHideFromPlayerList(), this.defaultConfig.getGeneral().isHideFromPlayerList(), val -> WailaConfigScreen.get().getGeneral().setHideFromPlayerList((boolean)val))).with(new BooleanValue("config.waila.hide_from_debug", WailaConfigScreen.get().getGeneral().isHideFromDebug(), this.defaultConfig.getGeneral().isHideFromDebug(), val -> WailaConfigScreen.get().getGeneral().setHideFromDebug((boolean)val))).with(new BooleanValue("config.waila.tts", WailaConfigScreen.get().getGeneral().isEnableTextToSpeech(), this.defaultConfig.getGeneral().isEnableTextToSpeech(), val -> WailaConfigScreen.get().getGeneral().setEnableTextToSpeech((boolean)val))).with(new InputValue<Integer>("config.waila.rate_limit", WailaConfigScreen.get().getGeneral().getRateLimit(), this.defaultConfig.getGeneral().getRateLimit(), val -> WailaConfigScreen.get().getGeneral().setRateLimit(Math.max(val, 250)), InputValue.POSITIVE_INTEGER)).with(new ButtonEntry("config.waila.blacklist", "config.waila.blacklist_open", 100, 20, w -> class_156.method_668().method_672(Waila.BLACKLIST_CONFIG.getPath().toFile()))));
        this.fpsVal = (ConfigValue)((Object)class_156.method_654(new InputValue<Integer>("config.waila.overlay_fps", WailaConfigScreen.get().getOverlay().getFps(), this.defaultConfig.getOverlay().getFps(), val -> WailaConfigScreen.get().getOverlay().setFps((int)val), InputValue.POSITIVE_INTEGER), it -> it.disable("config.waila.overlay_fps.disabled_reason")));
        this.xAnchorValue = new EnumValue("config.waila.overlay_anchor_x", (Enum[])IWailaConfig.Overlay.Position.Align.X.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAnchor().getX(), (Enum)this.defaultConfig.getOverlay().getPosition().getAnchor().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAnchor().setX((IWailaConfig.Overlay.Position.Align.X)((Object)val)));
        this.yAnchorValue = new EnumValue("config.waila.overlay_anchor_y", (Enum[])IWailaConfig.Overlay.Position.Align.Y.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAnchor().getY(), (Enum)this.defaultConfig.getOverlay().getPosition().getAnchor().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAnchor().setY((IWailaConfig.Overlay.Position.Align.Y)((Object)val)));
        this.xAlignValue = new EnumValue("config.waila.overlay_align_x", (Enum[])IWailaConfig.Overlay.Position.Align.X.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAlign().getX(), (Enum)this.defaultConfig.getOverlay().getPosition().getAlign().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAlign().setX((IWailaConfig.Overlay.Position.Align.X)((Object)val)));
        this.yAlignValue = new EnumValue("config.waila.overlay_align_y", (Enum[])IWailaConfig.Overlay.Position.Align.Y.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAlign().getY(), (Enum)this.defaultConfig.getOverlay().getPosition().getAlign().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAlign().setY((IWailaConfig.Overlay.Position.Align.Y)((Object)val)));
        this.xPosValue = new InputValue<Integer>("config.waila.overlay_pos_x", WailaConfigScreen.get().getOverlay().getPosition().getX(), this.defaultConfig.getOverlay().getPosition().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().setX((int)val), InputValue.INTEGER);
        this.yPosValue = new InputValue<Integer>("config.waila.overlay_pos_y", WailaConfigScreen.get().getOverlay().getPosition().getY(), this.defaultConfig.getOverlay().getPosition().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().setY((int)val), InputValue.INTEGER);
        this.scaleValue = new InputValue<Float>("config.waila.overlay_scale", Float.valueOf(WailaConfigScreen.get().getOverlay().getScale()), Float.valueOf(this.defaultConfig.getOverlay().getScale()), val -> WailaConfigScreen.get().getOverlay().setScale(Math.max(val.floatValue(), 0.0f)), InputValue.POSITIVE_DECIMAL);
        this.backgroundAlphaVal = new InputValue<Integer>("config.waila.overlay_background_alpha", WailaConfigScreen.get().getOverlay().getColor().getBackgroundAlpha(), this.defaultConfig.getOverlay().getColor().getBackgroundAlpha(), val -> WailaConfigScreen.get().getOverlay().getColor().setBackgroundAlpha(class_3532.method_15340((int)val, (int)0, (int)255)), InputValue.POSITIVE_INTEGER);
        this.themeIdVal = new ThemeValue();
        options.with(new CategoryEntry("config.waila.overlay").with(this.fpsVal).with(this.xAnchorValue).with(this.yAnchorValue).with(this.xAlignValue).with(this.yAlignValue).with(this.xPosValue).with(this.yPosValue).with(new BooleanValue("config.waila.boss_bars_overlap", WailaConfigScreen.get().getOverlay().getPosition().isBossBarsOverlap(), this.defaultConfig.getOverlay().getPosition().isBossBarsOverlap(), val -> WailaConfigScreen.get().getOverlay().getPosition().setBossBarsOverlap((boolean)val))).with(this.scaleValue).with(this.backgroundAlphaVal).with(this.themeIdVal));
        this.modNameFormatVal = new InputValue<String>("config.waila.format_mod_name", WailaConfigScreen.get().getFormatter().getModName(), this.defaultConfig.getFormatter().getModName(), val -> WailaConfigScreen.get().getFormatter().setModName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getModName() : val), InputValue.ANY);
        this.blockNameFormatVal = new InputValue<String>("config.waila.format_block_name", WailaConfigScreen.get().getFormatter().getBlockName(), this.defaultConfig.getFormatter().getBlockName(), val -> WailaConfigScreen.get().getFormatter().setBlockName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getBlockName() : val), InputValue.ANY);
        options.with(new CategoryEntry("config.waila.formatting").with(this.modNameFormatVal).with(this.blockNameFormatVal).with(new InputValue<String>("config.waila.format_fluid_name", WailaConfigScreen.get().getFormatter().getFluidName(), this.defaultConfig.getFormatter().getFluidName(), val -> WailaConfigScreen.get().getFormatter().setFluidName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getFluidName() : val), InputValue.ANY)).with(new InputValue<String>("config.waila.format_entity_name", WailaConfigScreen.get().getFormatter().getEntityName(), this.defaultConfig.getFormatter().getEntityName(), val -> WailaConfigScreen.get().getFormatter().setEntityName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getEntityName() : val), InputValue.ANY)).with(new InputValue<String>("config.waila.format_registry_name", WailaConfigScreen.get().getFormatter().getRegistryName(), this.defaultConfig.getFormatter().getRegistryName(), val -> WailaConfigScreen.get().getFormatter().setRegistryName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getRegistryName() : val), InputValue.ANY)));
        options.with(new CategoryEntry("config.waila.keybinds").with(new KeyBindValue(WailaClient.keyOpenConfig)).with(new KeyBindValue(WailaClient.keyShowOverlay)).with(new KeyBindValue(WailaClient.keyToggleLiquid)).with(new KeyBindValue(WailaClient.keyShowRecipeInput)).with(new KeyBindValue(WailaClient.keyShowRecipeOutput)));
        return options;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.selectedKeyBind != null) {
            this.selectedKeyBind.setValue(class_3675.class_307.field_1672.method_1447(button));
            this.selectedKeyBind = null;
            return true;
        }
        return this.f1held || super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.selectedKeyBind != null) {
            if (keyCode == 256) {
                this.selectedKeyBind.setValue(class_3675.field_16237);
            } else {
                this.selectedKeyBind.setValue(class_3675.method_15985((int)keyCode, (int)scanCode));
            }
            this.selectedKeyBind = null;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private class PreviewTooltipRendererState
    implements TooltipRenderer.State {
        private PreviewTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return true;
        }

        @Override
        public boolean fireEvent() {
            return false;
        }

        @Override
        public int getFps() {
            return WailaConfigScreen.this.fpsVal.getValue();
        }

        @Override
        public int getBackgroundAlpha() {
            return WailaConfigScreen.this.backgroundAlphaVal.getValue();
        }

        @Override
        public float getScale() {
            return WailaConfigScreen.this.scaleValue.getValue().floatValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return WailaConfigScreen.this.xAnchorValue.getValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return WailaConfigScreen.this.yAnchorValue.getValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return WailaConfigScreen.this.xAlignValue.getValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return WailaConfigScreen.this.yAlignValue.getValue();
        }

        @Override
        public int getX() {
            return WailaConfigScreen.this.xPosValue.getValue();
        }

        @Override
        public int getY() {
            return WailaConfigScreen.this.yPosValue.getValue();
        }

        @Override
        public boolean bossBarsOverlap() {
            return false;
        }

        @Override
        public ITheme getTheme() {
            return WailaConfigScreen.this.getTheme().getInitializedInstance();
        }

        @Override
        public boolean enableTextToSpeech() {
            return false;
        }
    }

    private class ThemeValue
    extends CycleValue {
        private final class_4185 editButton;
        private final class_4185 newButton;

        public ThemeValue() {
            super("config.waila.overlay_theme", (String[])ThemeDefinition.getAll().values().stream().map(t -> t.id.toString()).sorted(String::compareToIgnoreCase).toArray(String[]::new), WailaConfigScreen.get().getOverlay().getColor().getActiveTheme().toString(), val -> WailaConfigScreen.get().getOverlay().getColor().applyTheme(class_2960.method_60654((String)val)), false);
            this.editButton = DisplayUtil.createButton(0, 0, 40, 20, (class_2561)class_2561.method_43471((String)"config.waila.edit"), button -> this.client.method_1507((class_437)new ThemeEditorScreen(WailaConfigScreen.this, WailaConfigScreen.this.getTheme(), true)));
            this.newButton = DisplayUtil.createButton(0, 0, 40, 20, (class_2561)class_2561.method_43471((String)"config.waila.new"), button -> this.client.method_1507((class_437)new ThemeEditorScreen(WailaConfigScreen.this, WailaConfigScreen.this.getTheme(), false)));
            this.reloadEditButton();
        }

        private void reloadEditButton() {
            this.editButton.field_22763 = !ThemeDefinition.getAll().get((Object)class_2960.method_60654((String)((String)this.getValue()))).builtin;
        }

        @Override
        protected void gatherChildren(ImmutableList.Builder<class_364> children) {
            super.gatherChildren(children);
            children.add((Object)this.editButton);
            children.add((Object)this.newButton);
        }

        @Override
        public void setValue(String value) {
            super.setValue(value);
            this.reloadEditButton();
        }

        @Override
        protected void drawValue(class_332 ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.newButton.method_46421(x + width - this.newButton.method_25368());
            this.newButton.method_46419(y + (height - this.newButton.method_25364()) / 2);
            this.editButton.method_46421(this.newButton.method_46426() - this.newButton.method_25368() - 2);
            this.editButton.method_46419(this.newButton.method_46427());
            this.editButton.method_25394(ctx, mouseX, mouseY, partialTicks);
            this.newButton.method_25394(ctx, mouseX, mouseY, partialTicks);
            super.drawValue(ctx, width - 84, height, x, y, mouseX, mouseY, selected, partialTicks);
        }
    }

    public class KeyBindValue
    extends ConfigValue<class_3675.class_306> {
        private final class_4185 button;

        public KeyBindValue(class_304 key) {
            super(key.method_1431(), ((KeyMappingAccess)key).wthit_key(), key.method_1429(), value -> {
                key.method_1422(value);
                class_304.method_1426();
            });
            this.button = DisplayUtil.createButton(0, 0, 100, 20, (class_2561)class_2561.method_43473(), w -> {
                WailaConfigScreen.this.selectedKeyBind = this;
            });
        }

        @Override
        public class_364 getListener() {
            return this.button;
        }

        @Override
        protected void drawValue(class_332 ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (WailaConfigScreen.this.selectedKeyBind == this) {
                this.button.method_25355((class_2561)class_2561.method_43470((String)("> " + ((class_3675.class_306)this.getValue()).method_27445().getString() + " <")).method_27692(class_124.field_1054));
            } else {
                this.button.method_25355(((class_3675.class_306)this.getValue()).method_27445());
            }
            this.button.method_46421(x + width - this.button.method_25368());
            this.button.method_46419(y + (height - this.button.method_25364()) / 2);
            this.button.method_25394(ctx, mouseX, mouseY, partialTicks);
        }
    }
}

