/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.harvest.tool;

import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.api.__internal__.Internals;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9886;
import org.jetbrains.annotations.Nullable;

public final class ToolTier {
    public static final ToolTier NONE = Internals.unsafeAlloc(ToolTier.class);
    private static final Supplier<Map<class_2960, String>> VANILLA_TIER_TL_KEYS = Suppliers.memoize(() -> Map.of(class_9886.field_52585.comp_2930().comp_327(), "wood", class_9886.field_52586.comp_2930().comp_327(), "stone", class_9886.field_52587.comp_2930().comp_327(), "iron", class_9886.field_52588.comp_2930().comp_327(), "diamond", class_9886.field_52589.comp_2930().comp_327(), "gold", class_9886.field_52590.comp_2930().comp_327(), "netherite"));
    private static Supplier<Map<class_2960, ToolTier>> tiers;
    public final class_9886 tier;
    public final int index;
    public final class_6862<class_2248> incorrect;
    private final Supplier<String> tlKey;

    public ToolTier(class_9886 tier, int index) {
        this.tier = tier;
        this.index = index;
        this.incorrect = tier.comp_2930();
        this.tlKey = Suppliers.memoize(() -> {
            String vanilla = VANILLA_TIER_TL_KEYS.get().get(this.incorrect.comp_327());
            String key = vanilla != null ? vanilla : this.incorrect.comp_327().method_42094();
            return "tooltip.waila.harvest.tier." + key;
        });
    }

    public static void resetMap() {
        tiers = Suppliers.memoize(() -> {
            LinkedHashMap<class_2960, ToolTier> map = new LinkedHashMap<class_2960, ToolTier>();
            int index = 0;
            for (class_9886 tier : IApiService.INSTANCE.getTiers()) {
                class_2960 key = tier.comp_2930().comp_327();
                if (map.containsKey(key)) continue;
                map.put(key, new ToolTier(tier, index++));
            }
            return map;
        });
    }

    public static Collection<ToolTier> all() {
        return tiers.get().values();
    }

    @Nullable
    public static ToolTier get(class_1799 stack) {
        class_9424 stackTool = (class_9424)stack.method_57824(class_9334.field_50077);
        if (stackTool == null) {
            return null;
        }
        for (class_9424.class_9425 toolRule : stackTool.comp_2498()) {
            class_6885 class_68852;
            Boolean correctForDrops = toolRule.comp_2503().orElse(null);
            if (correctForDrops != Boolean.FALSE || !((class_68852 = toolRule.comp_2501()) instanceof class_6885.class_6888)) continue;
            class_6885.class_6888 named = (class_6885.class_6888)class_68852;
            return tiers.get().get(named.method_40251().comp_327());
        }
        return null;
    }

    public String tlKey() {
        return this.tlKey.get();
    }

    public boolean isEqualTo(ToolTier other) {
        if (this == other) {
            return true;
        }
        if (this.tier == other.tier) {
            return true;
        }
        if (this.incorrect != null && other.incorrect != null) {
            return this.incorrect.comp_327().equals((Object)other.incorrect.comp_327());
        }
        return false;
    }

    public boolean isBetterThanOrEqualTo(ToolTier other) {
        return this.isEqualTo(other) || this.index >= other.index;
    }

    static {
        ToolTier.resetMap();
    }
}

