/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.textile.provider;

import com.google.common.primitives.Ints;
import java.util.HashSet;
import java.util.Set;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.data.ItemData;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public enum ItemStorageProvider implements IDataProvider<class_2586>
{
    INSTANCE;

    @Nullable
    private @Nullable BlockApiCache<Storage<ItemVariant>, @Nullable class_2350> cache;

    @Override
    public void appendData(IDataWriter data, IServerAccessor<class_2586> accessor, IPluginConfig config) {
        data.add(ItemData.TYPE, res -> {
            Storage storage;
            if (this.cache == null || this.cache.getBlockEntity() != accessor.getTarget()) {
                this.cache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)accessor.getWorld()), (class_2338)((class_2586)accessor.getTarget()).method_11016());
            }
            if ((storage = (Storage)this.cache.find(((class_2586)accessor.getTarget()).method_11010(), null)) instanceof SingleSlotStorage) {
                SingleSlotStorage single = (SingleSlotStorage)storage;
                ItemData itemData = ItemData.of(config);
                this.addItem(itemData, (StorageView<ItemVariant>)single);
                res.add(itemData);
            } else if (storage instanceof SlottedStorage) {
                SlottedStorage slotted = (SlottedStorage)storage;
                int size = slotted.getSlotCount();
                ItemData itemData = ItemData.of(config);
                itemData.ensureSpace(size);
                for (int i = 0; i < size; ++i) {
                    SingleSlotStorage slot = slotted.getSlot(i);
                    this.addItem(itemData, (StorageView<ItemVariant>)slot);
                }
                res.add(itemData);
            } else if (storage != null) {
                HashSet<StorageView<ItemVariant>> uniqueViews = new HashSet<StorageView<ItemVariant>>();
                ItemData itemData = ItemData.of(config);
                for (StorageView view : storage) {
                    this.addItem(uniqueViews, itemData, (StorageView<ItemVariant>)view);
                }
                res.add(itemData);
            }
        });
    }

    private void addItem(Set<StorageView<ItemVariant>> uniqueViews, ItemData itemData, StorageView<ItemVariant> view) {
        StorageView uniqueView = view.getUnderlyingView();
        if (uniqueViews.add((StorageView<ItemVariant>)uniqueView)) {
            this.addItem(itemData, view);
        }
    }

    private void addItem(ItemData itemData, StorageView<ItemVariant> view) {
        if (view.isResourceBlank()) {
            return;
        }
        itemData.add(((ItemVariant)view.getResource()).toStack(Ints.saturatedCast((long)view.getAmount())));
    }
}

