/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.gui.hud.ComponentRenderer;
import mcp.mobius.waila.gui.hud.InspectComponent;
import mcp.mobius.waila.registry.PluginAware;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class Line
implements ITooltipLine {
    @Nullable
    public final ResourceLocation tag;
    public final List<ITooltipComponent> components = new ArrayList<ITooltipComponent>();
    public final Object2IntOpenHashMap<ITooltipComponent> widths = new Object2IntOpenHashMap();
    public final Object2IntMap<ITooltipComponent> heights = new Object2IntOpenHashMap();
    @Nullable
    public PluginAware<?> origin;
    private int fixedWidth = -1;
    private int width = -1;
    private int height = -1;
    private int growingWeight = 0;
    private int growingMinWidth = 0;

    public Line(@Nullable ResourceLocation tag) {
        this.tag = tag;
    }

    @Override
    public Line with(ITooltipComponent component) {
        component = InspectComponent.maybeWrap(component, this.origin, this.tag);
        this.components.add(component);
        if (component instanceof ITooltipComponent.HorizontalGrowing) {
            ITooltipComponent.HorizontalGrowing growing = (ITooltipComponent.HorizontalGrowing)component;
            this.growingWeight += growing.getWeight();
        }
        return this;
    }

    @Override
    public Line with(Component component) {
        return this.with(new WrappedComponent(component));
    }

    public void calculateFixedWidth() {
        if (this.fixedWidth != -1) {
            return;
        }
        this.fixedWidth = this.components.stream().mapToInt(c -> {
            int width = c.getWidth();
            if (c instanceof ITooltipComponent.HorizontalGrowing) {
                this.growingMinWidth += width;
            }
            this.widths.put(c, width);
            return width;
        }).sum();
    }

    public void calculateDynamicWidth(int maxWidth) {
        if (this.width != -1) {
            return;
        }
        if (this.growingWeight > 0) {
            int fixedWidth = this.fixedWidth - this.growingMinWidth;
            int unfrozenWeight = this.growingWeight;
            List calculate = this.components.stream().filter(it -> it instanceof ITooltipComponent.HorizontalGrowing).map(it -> (ITooltipComponent.HorizontalGrowing)it).collect(Collectors.toCollection(ArrayList::new));
            while (!calculate.isEmpty()) {
                float growingWidth = -1.0f;
                boolean success = true;
                Iterator iterator = calculate.iterator();
                while (iterator.hasNext()) {
                    int newWidth;
                    int weightedWidth;
                    ITooltipComponent.HorizontalGrowing growing = (ITooltipComponent.HorizontalGrowing)iterator.next();
                    if (growingWidth == -1.0f) {
                        growingWidth = (float)(maxWidth - fixedWidth) / (float)unfrozenWeight;
                    }
                    if ((weightedWidth = (int)(growingWidth * (float)growing.getWeight())) > growing.getMinimalWidth()) {
                        newWidth = weightedWidth;
                    } else {
                        newWidth = growing.getMinimalWidth();
                        fixedWidth += newWidth + 1;
                        unfrozenWeight -= growing.getWeight();
                        iterator.remove();
                        success = false;
                    }
                    growing.setGrownWidth(newWidth);
                    this.widths.put((Object)growing, newWidth);
                }
                if (!success) continue;
                break;
            }
        }
        this.width = this.components.stream().mapToInt(c -> {
            int width = this.widths.getInt(c);
            return width > 0 ? width + 1 : 0;
        }).sum();
        if (this.width > 0) {
            --this.width;
        }
    }

    public void calculateHeight() {
        if (this.height != -1) {
            return;
        }
        this.height = this.components.stream().mapToInt(c -> {
            int height = c.getHeight();
            this.heights.put(c, height);
            return height;
        }).max().orElse(0);
    }

    public int getFixedWidth() {
        Preconditions.checkState((this.fixedWidth != -1 ? 1 : 0) != 0);
        return this.fixedWidth;
    }

    public int getWidth() {
        Preconditions.checkState((this.width != -1 ? 1 : 0) != 0);
        return this.width;
    }

    public int getHeight() {
        Preconditions.checkState((this.height != -1 ? 1 : 0) != 0);
        return this.height;
    }

    public void render(ComponentRenderer renderer, PoseStack matrices, int x, int y, float delta) {
        Preconditions.checkState((this.width != -1 && this.height != -1 ? 1 : 0) != 0);
        int cx = x;
        for (ITooltipComponent component : this.components) {
            int w = this.widths.getInt((Object)component);
            if (w <= 0) continue;
            int h = this.heights.getInt((Object)component);
            int cy = y + (h < this.height ? (this.height - h) / 2 : 0);
            renderer.render(matrices, component, cx, cy, w, h, delta);
            cx += w + 1;
        }
    }
}

