/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.awt.Rectangle;
import java.util.Objects;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.mixed.MMultiPlayerGameMode;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public enum BreakProgressProvider implements IEventListener
{
    INSTANCE;

    static final int FADE_TICK = 3;
    boolean wasBreaking = false;
    float targetProgress = 0.0f;
    float lastProgress = 0.0f;
    boolean fadeFinish = false;
    int fadeTicks = 0;
    float fade = 0.0f;

    @Override
    public void onTick(IPluginConfig config) {
        boolean isBreaking;
        this.targetProgress = 0.0f;
        if (this.fadeFinish) {
            this.fade = 0.0f;
            this.lastProgress = 0.0f;
            this.fadeFinish = false;
        }
        if (!config.getBoolean(Options.BREAKING_PROGRESS)) {
            return;
        }
        MMultiPlayerGameMode gameMode = (MMultiPlayerGameMode)Objects.requireNonNull(class_310.method_1551().field_1761);
        this.targetProgress = gameMode.wthit_destroyProgress();
        boolean bl = isBreaking = this.targetProgress > 0.0f;
        if (this.wasBreaking && !isBreaking) {
            this.fadeTicks = 3;
            this.fade = this.fadeTicks;
            if (gameMode.wthit_wasDestroyed()) {
                this.targetProgress = 1.0f;
            }
        }
        this.wasBreaking = isBreaking;
        if (this.fadeTicks > 0) {
            --this.fadeTicks;
            if (this.fadeTicks == 0) {
                this.fadeFinish = true;
            }
        }
    }

    @Override
    public void onAfterTooltipRender(class_332 ctx, Rectangle rect, ICommonAccessor accessor, IPluginConfig config) {
        float lineLength;
        float dt = class_310.method_1551().method_61966().method_60638();
        float progress = this.lastProgress;
        if (this.targetProgress > this.lastProgress) {
            float progressChange = (this.targetProgress - this.lastProgress) * dt;
            progress = class_3532.method_15363((float)(this.lastProgress + progressChange), (float)0.0f, (float)1.0f);
        }
        this.lastProgress = progress;
        if (progress <= 0.0f && this.fade <= 0.0f) {
            return;
        }
        boolean bottomOnly = config.getBoolean(Options.BREAKING_PROGRESS_BOTTOM_ONLY);
        float f = lineLength = bottomOnly ? (float)(rect.width - 2) * progress : (float)((rect.width - 2 + (rect.height - 2)) * 2) * progress;
        if (lineLength >= 1.0f) {
            int hLength = rect.width - 2;
            int vLength = rect.height - 4;
            int x = rect.x + 1;
            int y = rect.y + rect.height - 2;
            int color = config.getInt(Options.BREAKING_PROGRESS_COLOR);
            float alpha = this.fade > 0.0f ? this.fade / 3.0f : 1.0f;
            int a = (int)(alpha * (float)(color >> 24 & 0xFF));
            color = color & 0xFFFFFF | a << 24;
            ctx.method_51738(x, x + Math.round(Math.min(lineLength, (float)hLength)) - 1, y, color);
            lineLength -= (float)hLength;
            if (lineLength > 0.0f) {
                x = rect.x + rect.width - 2;
                y = rect.y + rect.height - 2;
                ctx.method_51742(x, y, y - Math.round(Math.min(lineLength, (float)vLength)) - 1, color);
                lineLength -= (float)vLength;
                if (lineLength > 0.0f) {
                    x = rect.x + rect.width - 2;
                    y = rect.y + 1;
                    ctx.method_51738(x, x - Math.round(Math.min(lineLength, (float)hLength)) + 1, y, color);
                    lineLength -= (float)hLength;
                    if (lineLength > 0.0f) {
                        x = rect.x + 1;
                        y = rect.y + 1;
                        ctx.method_51742(x, y, y + Math.round(Math.min(lineLength, (float)vLength)) + 1, color);
                    }
                }
            }
        }
        if (this.fade > 0.0f) {
            this.fade = Math.max(this.fade - dt, 0.0f);
        }
    }
}

