/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IApiService;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

@ApiSide.ClientOnly
public class WrappedComponent
implements ITooltipComponent {
    public final Component component;
    private List<FormattedCharSequence> lines;
    private int height;

    public WrappedComponent(String literal) {
        this((Component)Component.literal((String)literal));
    }

    public WrappedComponent(Component component) {
        this.component = component;
    }

    @Override
    public int getWidth() {
        Font font = this.getFont();
        List split = font.getSplitter().splitLines((FormattedText)this.component, Integer.MAX_VALUE, Style.EMPTY);
        this.lines = Language.getInstance().getVisualOrder(split);
        int width = this.lines.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(0);
        Objects.requireNonNull(font);
        this.height = 9 * split.size();
        return width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        Font font = this.getFont();
        for (FormattedCharSequence line : this.lines) {
            ctx.drawString(font, line, x, y, IApiService.INSTANCE.getFontColor());
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    private Font getFont() {
        return Minecraft.getInstance().font;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrappedComponent that = (WrappedComponent)o;
        return this.component.equals((Object)that.component);
    }

    public int hashCode() {
        return Objects.hash(this.component);
    }
}

