/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigListWidget
extends ContainerObjectSelectionList<Entry> {
    private final ConfigScreen owner;
    @Nullable
    private final Runnable diskWriter;
    public final Set<ConfigValue<?, ?>> values = new HashSet();
    private int topOffset;
    private int bottomOffset;
    public boolean headerSeparator = true;
    public boolean footerSeparator = true;
    public boolean enableSearchBox = true;
    @Nullable
    private SearchBoxEntry searchBox;
    @Nullable
    public String filter = null;
    public String @Nullable [] splitFilter = null;

    public ConfigListWidget(ConfigScreen owner, Minecraft client, int width, int height, int top, int bottom, int itemHeight, @Nullable Runnable diskWriter) {
        super(client, width, height, top, itemHeight - 4);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.resize(top, bottom);
    }

    public ConfigListWidget(ConfigScreen owner, Minecraft client, int width, int height, int top, int bottom, int itemHeight) {
        this(owner, client, width, height, top, bottom, itemHeight, null);
    }

    public boolean isChanged() {
        return this.values.stream().anyMatch(ConfigValue::isChanged);
    }

    public int getRowWidth() {
        return Math.min(this.width - 20, 450);
    }

    protected int scrollBarX() {
        return this.minecraft.getWindow().getGuiScaledWidth() - 5;
    }

    public void tick() {
        this.children().forEach(Entry::tick);
    }

    public boolean save(boolean ignoreErrors) {
        if (this.values.stream().allMatch(ConfigValue::isValueValid)) {
            this.values.forEach(ConfigValue::save);
            if (this.diskWriter != null) {
                this.diskWriter.run();
            }
            return true;
        }
        if (!ignoreErrors) {
            ConfigListWidget.showErrorToast(this.minecraft);
        }
        return ignoreErrors;
    }

    public static void showErrorToast(Minecraft minecraft) {
        minecraft.getToastManager().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PACK_COPY_FAILURE, (Component)Component.translatable((String)"config.waila.invalid_input.title"), (Component)Component.translatable((String)"config.waila.invalid_input.desc")));
    }

    public void search() {
        Preconditions.checkState((boolean)this.enableSearchBox);
        Objects.requireNonNull(this.searchBox);
        this.centerScrollOn((AbstractSelectionList.Entry)this.searchBox);
        this.owner.setInitialFocus((GuiEventListener)this.searchBox.box);
    }

    public void init() {
        List<Entry> dirtyChildren = List.copyOf(this.children());
        for (Entry child : dirtyChildren) {
            child.clear(this);
        }
        List<Entry> rootChildren = List.copyOf(this.children());
        int index = 0;
        if (this.enableSearchBox && this.searchBox == null) {
            EditBox box = new EditBox(this.minecraft.font, 0, 0, 160, 18, (Component)Component.empty());
            box.setHint((Component)Component.translatable((String)"config.waila.search_prompt"));
            box.setResponder(filter -> {
                boolean isBlank = filter.isBlank();
                if (isBlank && this.filter == null || filter.equals(this.filter)) {
                    return;
                }
                this.children().clear();
                this.children().add(this.searchBox);
                if (isBlank) {
                    this.filter = null;
                    this.splitFilter = null;
                    this.children().addAll(rootChildren);
                } else {
                    this.filter = filter;
                    this.splitFilter = filter.split("\\s");
                    this.children().addAll(rootChildren.stream().filter(it -> it.match(this.splitFilter)).toList());
                }
                this.init();
                this.search();
            });
            this.searchBox = new SearchBoxEntry(box);
            this.with(0, this.searchBox);
            this.searchBox.init(this, 0);
            ++index;
        }
        for (Entry child : rootChildren) {
            index += child.init(this, index);
        }
        for (Entry child : this.children()) {
            child.setFocused(null);
        }
        this.resize(this.topOffset, this.owner.height + this.bottomOffset);
        this.setScrollAmount(this.scrollAmount());
    }

    public ConfigListWidget with(Entry entry) {
        return this.with(this.children().size(), entry);
    }

    public ConfigListWidget with(int index, Entry entry) {
        if (entry instanceof ConfigValue) {
            ConfigValue cv = (ConfigValue)entry;
            this.withHidden(cv);
        }
        this.children().add(index, entry);
        return this;
    }

    public ConfigListWidget withHidden(ConfigValue<?, ?> value) {
        this.values.add(value);
        return this;
    }

    public void resize(int top, int bottom) {
        this.topOffset = top;
        this.bottomOffset = bottom - this.owner.height;
        this.setSize(this.owner.width, this.owner.height - (this.topOffset - this.bottomOffset));
    }

    protected void renderListSeparators(GuiGraphics ctx) {
        ResourceLocation texture;
        if (this.headerSeparator) {
            texture = this.minecraft.level == null ? Screen.HEADER_SEPARATOR : Screen.INWORLD_HEADER_SEPARATOR;
            ctx.blit(RenderType::guiTextured, texture, this.getX(), this.getY() - 2, 0.0f, 0.0f, this.getWidth(), 2, 32, 2);
        }
        if (this.footerSeparator) {
            texture = this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
            ctx.blit(RenderType::guiTextured, texture, this.getX(), this.getBottom(), 0.0f, 0.0f, this.getWidth(), 2, 32, 2);
        }
    }

    private static class SearchBoxEntry
    extends Entry {
        final EditBox box;

        private SearchBoxEntry(EditBox box) {
            this.box = box;
        }

        @Override
        protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
            children.add((Object)this.box);
        }

        @Override
        public boolean match(String[] filter) {
            return true;
        }

        @Override
        protected void buildSearchKey(StringBuilder sb) {
            throw new IllegalStateException();
        }

        @Override
        protected void drawEntry(GuiGraphics ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            this.box.setPosition(rowLeft, rowTop);
            this.box.setWidth(width);
            this.box.render(ctx, mouseX, mouseY, deltaTime);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected final Minecraft client = Minecraft.getInstance();
        @Nullable
        protected List<? extends GuiEventListener> children;
        @Nullable
        protected List<? extends NarratableEntry> narratables;
        protected ConfigListWidget list;
        protected int index;
        @Nullable
        public CategoryEntry category;
        public int categoryDepth;

        public void tick() {
        }

        public final int init(ConfigListWidget list, int index) {
            Preconditions.checkState((list.children().get(index) == this ? 1 : 0) != 0);
            this.list = list;
            this.index = index;
            return this.init();
        }

        public int init() {
            return 1;
        }

        public void clear(ConfigListWidget list) {
        }

        protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
        }

        protected void gatherNarratables(ImmutableList.Builder<NarratableEntry> narratables) {
        }

        protected abstract void buildSearchKey(StringBuilder var1);

        public boolean match(String[] filter) {
            StringBuilder sb = new StringBuilder();
            this.buildSearchKey(sb);
            for (String s : filter) {
                if (!StringUtils.containsIgnoreCase((CharSequence)sb.toString(), (CharSequence)s)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            if (this.children == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.gatherChildren((ImmutableList.Builder<GuiEventListener>)builder);
                this.children = builder.build();
            }
            return this.children;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            if (this.narratables == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.gatherNarratables((ImmutableList.Builder<NarratableEntry>)builder);
                this.narratables = builder.build();
            }
            return this.narratables;
        }

        public final void render(@NotNull GuiGraphics ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            if (this.category != null) {
                for (int i = 0; i < this.categoryDepth; ++i) {
                    int lineX1 = rowLeft + 5 + i * 16;
                    int lineX2 = lineX1 + 2;
                    int lineY1 = rowTop - height / 2 - 4;
                    int lineY2 = lineY1 + height + 4;
                    if (i == this.categoryDepth - 1 && index - this.category.index == 1) {
                        lineY1 += 8;
                    }
                    ctx.fill(lineX1, lineY1, lineX2, lineY2, 0x22FAFAFA);
                }
                int offset = this.categoryDepth * 16;
                rowLeft += offset;
                width -= offset;
            }
            this.drawEntry(ctx, index, rowTop, rowLeft, width, height, mouseX, mouseY, hovered, deltaTime);
        }

        protected abstract void drawEntry(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);
    }
}

