/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import java.util.List;
import lol.bai.badpackets.api.PacketSender;
import lol.bai.badpackets.api.config.ConfigPackets;
import lol.bai.badpackets.api.play.PlayPackets;
import mcp.mobius.waila.network.Packet;
import mcp.mobius.waila.network.common.VersionCommonPacket;
import mcp.mobius.waila.network.common.s2c.BlacklistSyncCommonS2CPacket;
import mcp.mobius.waila.network.common.s2c.ConfigSyncCommonS2CPacket;
import mcp.mobius.waila.network.common.s2c.PluginSyncCommonS2CPacket;
import mcp.mobius.waila.network.play.c2s.BlockDataRequestPlayC2SPacket;
import mcp.mobius.waila.network.play.c2s.ConfigSyncRequestPlayC2SPacket;
import mcp.mobius.waila.network.play.c2s.EntityDataRequestPlayC2SPacket;
import mcp.mobius.waila.network.play.c2s.RawDataRequestContextPlayC2SPacket;
import mcp.mobius.waila.network.play.c2s.TypedDataRequestContextPlayC2SPacket;
import mcp.mobius.waila.network.play.s2c.GenerateClientDumpPlayS2CPacket;
import mcp.mobius.waila.network.play.s2c.RawDataResponsePlayS2CPacket;
import mcp.mobius.waila.network.play.s2c.TypedDataResponsePlayS2CPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class Packets {
    private static final List<Packet> PACKETS = List.of(new VersionCommonPacket(), new BlacklistSyncCommonS2CPacket(), new ConfigSyncCommonS2CPacket(), new PluginSyncCommonS2CPacket(), new BlockDataRequestPlayC2SPacket(), new ConfigSyncRequestPlayC2SPacket(), new EntityDataRequestPlayC2SPacket(), new RawDataRequestContextPlayC2SPacket(), new TypedDataRequestContextPlayC2SPacket(), new GenerateClientDumpPlayS2CPacket(), new RawDataResponsePlayS2CPacket(), new TypedDataResponsePlayS2CPacket());

    public static void initServer() {
        PACKETS.forEach(Packet::common);
        ConfigPackets.registerServerReadyCallback(Packets::sendS2CHandshakePackets);
        PlayPackets.registerServerReadyCallback(context -> {
            if (context.canSend(VersionCommonPacket.TYPE)) {
                Packets.sendS2CHandshakePackets((PacketSender)context);
            }
        });
    }

    public static void initClient() {
        PACKETS.forEach(Packet::client);
        ConfigPackets.registerClientReadyCallback(Packets::sendVersionPacket);
    }

    private static boolean sendVersionPacket(PacketSender sender) {
        if (!sender.canSend(VersionCommonPacket.TYPE)) {
            return false;
        }
        sender.send((CustomPacketPayload)new VersionCommonPacket.Payload(10));
        return true;
    }

    private static void sendS2CHandshakePackets(PacketSender sender) {
        if (!Packets.sendVersionPacket(sender)) {
            return;
        }
        sender.send((CustomPacketPayload)new PluginSyncCommonS2CPacket.Payload());
        sender.send((CustomPacketPayload)new BlacklistSyncCommonS2CPacket.Payload());
        sender.send((CustomPacketPayload)new ConfigSyncCommonS2CPacket.Payload());
    }
}

