/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network.play.c2s;

import lol.bai.badpackets.api.PacketSender;
import lol.bai.badpackets.api.play.PlayPackets;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataReader;
import mcp.mobius.waila.access.DataWriter;
import mcp.mobius.waila.access.ServerAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.network.Packet;
import mcp.mobius.waila.registry.Registrar;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityDataRequestPlayC2SPacket
implements Packet {
    public static final CustomPacketPayload.Type<Payload> TYPE = new CustomPacketPayload.Type(Waila.id("entity"));
    public static final StreamCodec<FriendlyByteBuf, Payload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Payload::entityId, (StreamCodec)StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, Vec3::x, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::y, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::z, Vec3::new), Payload::hitPos, Payload::new);

    @Override
    public void common() {
        PlayPackets.registerServerChannel(TYPE, CODEC);
        PlayPackets.registerServerReceiver(TYPE, (context, payload) -> {
            ServerPlayer player = context.player();
            int entityId = payload.entityId;
            Vec3 hitPos = payload.hitPos;
            Registrar registrar = Registrar.get();
            Level world = player.level();
            Entity entity = world.getEntity(entityId);
            if (entity == null) {
                return;
            }
            CompoundTag raw = DataWriter.SERVER.reset();
            IServerAccessor accessor = ServerAccessor.INSTANCE.set(world, player, (HitResult)new EntityHitResult(entity, hitPos), entity);
            for (IInstanceRegistry.Entry<IDataProvider<Entity>> provider : registrar.entityData.get(entity)) {
                DataWriter.SERVER.tryAppend((Player)player, provider.instance(), accessor, PluginConfig.SERVER, IDataProvider::appendData);
            }
            raw.putInt("WailaEntityID", entity.getId());
            raw.putLong("WailaTime", System.currentTimeMillis());
            DataWriter.SERVER.send((PacketSender)context, (Player)player);
            DataReader.SERVER.reset(null);
        });
    }

    public record Payload(int entityId, Vec3 hitPos) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

