/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.harvest.tool;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.api.__internal__.Internals;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class ToolTier {
    public static final ToolTier NONE = Internals.unsafeAlloc(ToolTier.class);
    private static final Supplier<Map<ResourceLocation, String>> VANILLA_TIER_TL_KEYS = Suppliers.memoize(() -> {
        HashMap<ResourceLocation, String> map = new HashMap<ResourceLocation, String>();
        for (Tiers tier : Tiers.values()) {
            map.put(tier.getIncorrectBlocksForDrops().location(), tier.name().toLowerCase(Locale.ROOT));
        }
        return map;
    });
    private static Supplier<Map<Tier, ToolTier>> tiers;
    public final Tier tier;
    public final int index;
    public final TagKey<Block> incorrect;
    private final Supplier<String> tlKey;

    public ToolTier(Tier tier, int index) {
        this.tier = tier;
        this.index = index;
        this.incorrect = tier.getIncorrectBlocksForDrops();
        this.tlKey = Suppliers.memoize(() -> {
            String vanilla = VANILLA_TIER_TL_KEYS.get().get(this.incorrect.location());
            String key = vanilla != null ? vanilla : this.incorrect.location().toLanguageKey();
            return "tooltip.waila.harvest.tier." + key;
        });
    }

    public static void resetMap() {
        tiers = Suppliers.memoize(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            List<Tier> tiers = IApiService.INSTANCE.getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                Tier tier = tiers.get(i);
                builder.put((Object)tier, (Object)new ToolTier(tier, i));
            }
            return builder.build();
        });
    }

    public static Collection<ToolTier> all() {
        return tiers.get().values();
    }

    @Nullable
    public static ToolTier get(Tier tier) {
        return tiers.get().get(tier);
    }

    public String tlKey() {
        return this.tlKey.get();
    }

    public boolean isEqualTo(ToolTier other) {
        if (this == other) {
            return true;
        }
        if (this.tier == other.tier) {
            return true;
        }
        if (this.incorrect != null && other.incorrect != null) {
            return this.incorrect.location().equals((Object)other.incorrect.location());
        }
        return false;
    }

    public boolean isBetterThanOrEqualTo(ToolTier other) {
        return this.isEqualTo(other) || this.index >= other.index;
    }

    static {
        ToolTier.resetMap();
    }
}

