/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.IntFunction;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.__internal__.IExtraService;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public abstract class ProgressData
implements IData {
    public static final class_2960 ID = BuiltinDataUtil.rl("progress");
    public static final class_2960 CONFIG_TIME = BuiltinDataUtil.rl("progress.time");
    public static final class_2960 CONFIG_BAR_HEIGHT = BuiltinDataUtil.rl("progress.height");
    public static final class_2960 CONFIG_REPLACE_ITEMS = BuiltinDataUtil.rl("progress.replace_items");
    protected final ArrayList<class_1799> input = new ArrayList();
    protected final ArrayList<class_1799> output = new ArrayList();
    protected IntFunction<class_1799> itemGetter;

    public static ProgressData ratio(float ratio) {
        return IExtraService.INSTANCE.createRatioProgressData(class_3532.method_15363((float)ratio, (float)0.0f, (float)1.0f));
    }

    public static ProgressData tick(int current, int total) {
        return IExtraService.INSTANCE.createTickProgressData(current, total);
    }

    public ProgressData input(class_1799 stack) {
        this.input.add(stack);
        return this;
    }

    public ProgressData input(class_1799 ... stacks) {
        this.ensureInputSpace(stacks.length);
        Collections.addAll(this.input, stacks);
        return this;
    }

    public ProgressData input(Collection<class_1799> stacks) {
        this.input.addAll(stacks);
        return this;
    }

    public ProgressData input(int slot) {
        this.assertInventory();
        return this.input(this.itemGetter.apply(slot));
    }

    public ProgressData input(int ... slots) {
        this.assertInventory();
        this.ensureInputSpace(slots.length);
        for (int slot : slots) {
            this.input.add(this.itemGetter.apply(slot));
        }
        return this;
    }

    public ProgressData output(class_1799 stack) {
        this.output.add(stack);
        return this;
    }

    public ProgressData output(class_1799 ... stacks) {
        this.ensureOutputSpace(stacks.length);
        Collections.addAll(this.output, stacks);
        return this;
    }

    public ProgressData output(Collection<class_1799> stacks) {
        this.output.addAll(stacks);
        return this;
    }

    public ProgressData output(int slot) {
        this.assertInventory();
        return this.output(this.itemGetter.apply(slot));
    }

    public ProgressData output(int ... slots) {
        this.assertInventory();
        this.ensureOutputSpace(slots.length);
        for (int slot : slots) {
            this.output.add(this.itemGetter.apply(slot));
        }
        return this;
    }

    public ProgressData itemGetter(IntFunction<class_1799> getter) {
        this.itemGetter = getter;
        return this;
    }

    public ProgressData ensureInputSpace(int length) {
        this.ensureSpace(this.input, length);
        return this;
    }

    public ProgressData ensureOutputSpace(int length) {
        this.ensureSpace(this.output, length);
        return this;
    }

    @ApiStatus.Internal
    private void assertInventory() {
        Preconditions.checkState((this.itemGetter != null ? 1 : 0) != 0, (Object)"Call itemGetter() with stack getter first");
    }

    @ApiStatus.Internal
    private void ensureSpace(ArrayList<class_1799> list, int toAdd) {
        list.ensureCapacity(list.size() + toAdd);
    }
}

