/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.plugin.vanilla.config.NoteDisplayMode;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_156;
import net.minecraft.class_2428;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public enum NoteBlockProvider implements IBlockComponentProvider
{
    INSTANCE;

    private static final int[] COLORS;

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.NOTE_BLOCK_TYPE)) {
            class_2680 state = accessor.getBlockState();
            class_2766 instrument = (class_2766)state.method_11654((class_2769)class_2428.field_11325);
            int level = (Integer)state.method_11654((class_2769)class_2428.field_11324);
            Note note = Note.get(level);
            StringBuilder builder = new StringBuilder().append(" (").append(config.getEnum(Options.NOTE_BLOCK_NOTE) == NoteDisplayMode.SHARP ? note.sharp : note.flat).append(")");
            if (config.getBoolean(Options.NOTE_BLOCK_INT_VALUE)) {
                builder.append(" (").append(level).append(")");
            }
            tooltip.setLine(Options.NOTE_BLOCK_NOTE).with((class_2561)class_2561.method_43471((String)("tooltip.waila.instrument." + instrument.method_15434()))).with((class_2561)class_2561.method_43470((String)builder.toString()).method_27694(style -> style.method_36139(COLORS[level])));
        }
    }

    static {
        COLORS = (int[])class_156.method_654((Object)new int[25], arr -> {
            float twoPi = (float)Math.PI * 2;
            float onePerThree = 0.33333334f;
            float twoPerThree = 0.6666667f;
            for (int i = 0; i < ((int[])arr).length; ++i) {
                float levelF = (float)i / 24.0f;
                int r = (int)(255.0f * class_3532.method_15363((float)(class_3532.method_15374((float)(levelF * twoPi)) * 0.65f + 0.35f), (float)0.0f, (float)1.0f));
                int g = (int)(255.0f * class_3532.method_15363((float)(class_3532.method_15374((float)((levelF + onePerThree) * twoPi)) * 0.65f + 0.35f), (float)0.0f, (float)1.0f));
                int b = (int)(255.0f * class_3532.method_15363((float)(class_3532.method_15374((float)((levelF + twoPerThree) * twoPi)) * 0.65f + 0.35f), (float)0.0f, (float)1.0f));
                arr[i] = (r << 16) + (g << 8) + b;
            }
        });
    }

    private static enum Note {
        FS("F\u266f", "G\u266d"),
        G("G"),
        GS("G\u266f", "A\u266d"),
        A("A"),
        AS("A\u266f", "B\u266d"),
        B("B"),
        C("C"),
        CS("C\u266f", "D\u266d"),
        D("D"),
        DS("D\u266f", "E\u266d"),
        E("E"),
        F("F");

        static final Note[] VALUES;
        final String sharp;
        final String flat;

        private Note(String sharp, String flat) {
            this.sharp = sharp;
            this.flat = flat;
        }

        private Note(String note) {
            this(note, note);
        }

        static Note get(int level) {
            return VALUES[level % VALUES.length];
        }

        static {
            VALUES = Note.values();
        }
    }
}

