/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import org.texboobcat.questory.client.gui.ChapterArtEditorScreen;
import org.texboobcat.questory.client.gui.ChapterTabPanel;
import org.texboobcat.questory.quest.ChapterData;

public class ChapterDefaultsTabPanel
extends ChapterTabPanel {
    private class_342 shapeField;
    private class_342 sizeField;
    private class_342 minWidthField;
    private class_4185 hideLinesBtn;
    private boolean hideLines = false;

    public ChapterDefaultsTabPanel(ChapterArtEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int fieldX = this.x + 180;
        int fieldY = this.y + 20;
        int fieldW = 150;
        this.shapeField = this.createField(fieldX, fieldY, fieldW, "square, circle, hexagon...");
        this.sizeField = this.createField(fieldX, fieldY += 26, 80, "1.0");
        this.minWidthField = this.createField(fieldX, fieldY += 26, 80, "0");
        this.hideLinesBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hide Dependency Lines: No"), b -> this.toggleHideLines()).method_46434(fieldX, fieldY += 30, 200, 20).method_46431();
    }

    private void toggleHideLines() {
        this.hideLines = !this.hideLines;
        this.hideLinesBtn.method_25355((class_2561)class_2561.method_43470((String)("Hide Dependency Lines: " + (this.hideLines ? "Yes" : "No"))));
    }

    @Override
    public void loadFromChapter(ChapterData chapter) {
        this.shapeField.method_1852(chapter.getDefaultQuestShape());
        this.sizeField.method_1852(String.valueOf(chapter.getDefaultQuestSize()));
        this.minWidthField.method_1852(String.valueOf(chapter.getDefaultMinWidth()));
        this.hideLines = chapter.isDefaultHideDependencyLines();
        this.hideLinesBtn.method_25355((class_2561)class_2561.method_43470((String)("Hide Dependency Lines: " + (this.hideLines ? "Yes" : "No"))));
    }

    @Override
    public void saveToChapter(ChapterData chapter) {
        chapter.setDefaultQuestShape(this.shapeField.method_1882().trim());
        try {
            double size = Double.parseDouble(this.sizeField.method_1882().trim());
            chapter.setDefaultQuestSize(Math.max(0.1, Math.min(5.0, size)));
        }
        catch (Exception size) {
            // empty catch block
        }
        try {
            int minWidth = Integer.parseInt(this.minWidthField.method_1882().trim());
            chapter.setDefaultMinWidth(Math.max(0, minWidth));
        }
        catch (Exception exception) {
            // empty catch block
        }
        chapter.setDefaultHideDependencyLines(this.hideLines);
    }

    @Override
    public void render(class_332 g, int mouseX, int mouseY, float partialTick) {
        int fieldX = this.x + 12;
        int fieldY = this.y + 20;
        int labelW = 160;
        g.method_44379(this.x, this.y, this.x + this.w, this.y + this.h);
        g.method_25303(this.getFont(), "\u00a7lDefault Quest Properties", fieldX, fieldY - 8, -86);
        g.method_25303(this.getFont(), "\u00a77Applied to new quests in this chapter", fieldX, fieldY + 4, -5592406);
        g.method_25303(this.getFont(), "Default Quest Shape:", fieldX, fieldY += 20, -1);
        this.shapeField.method_46419(fieldY);
        this.shapeField.method_46421(fieldX + labelW);
        this.shapeField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "Default Quest Size:", fieldX, fieldY += 26, -1);
        this.sizeField.method_46419(fieldY);
        this.sizeField.method_46421(fieldX + labelW);
        this.sizeField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "(0.5 - 3.0)", fieldX + labelW + 88, fieldY, -7829368);
        g.method_25303(this.getFont(), "Default Min Width:", fieldX, fieldY += 26, -1);
        this.minWidthField.method_46419(fieldY);
        this.minWidthField.method_46421(fieldX + labelW);
        this.minWidthField.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25303(this.getFont(), "(min panel width)", fieldX + labelW + 88, fieldY, -7829368);
        g.method_25303(this.getFont(), "Dependency Lines:", fieldX, fieldY += 30, -1);
        this.hideLinesBtn.method_46419(fieldY);
        this.hideLinesBtn.method_46421(fieldX + labelW);
        this.hideLinesBtn.method_25394(g, mouseX, mouseY, partialTick);
        g.method_44380();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hideLinesBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

