/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.fabric.mixin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.events.QuestEvents;
import org.texboobcat.questory.manager.QuestManager;

@Mixin(value={class_1657.class})
public class PlayerMixin {
    @Unique
    private int questory$inventoryCheckTicks = 0;
    @Unique
    private int questory$statisticsCheckTicks = 0;
    @Unique
    private Map<String, Integer> questory$previousInventory = null;
    @Unique
    private Map<String, class_3445<?>> questory$statCache = new HashMap();
    @Unique
    private Map<String, Integer> questory$lastStatValues = new HashMap<String, Integer>();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (this.questory$inventoryCheckTicks == 0) {
            // empty if block
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (++this.questory$inventoryCheckTicks >= 5) {
                this.questory$inventoryCheckTicks = 0;
                this.questory$checkInventoryChanges(serverPlayer);
            }
            if (++this.questory$statisticsCheckTicks >= 100) {
                this.questory$statisticsCheckTicks = 0;
                this.questory$checkStatistics(serverPlayer);
            }
        } else {
            ++this.questory$inventoryCheckTicks;
            ++this.questory$statisticsCheckTicks;
        }
    }

    @Unique
    private void questory$checkInventoryChanges(class_3222 player) {
        Object itemId;
        if (this.questory$previousInventory == null) {
            this.questory$previousInventory = new HashMap<String, Integer>();
        }
        HashMap<String, Integer> currentInventory = new HashMap<String, Integer>();
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960()) continue;
            itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            String key = itemId.toString();
            currentInventory.put(key, currentInventory.getOrDefault(key, 0) + stack.method_7947());
        }
        for (Map.Entry entry : currentInventory.entrySet()) {
            int previousCount;
            itemId = (String)entry.getKey();
            int currentCount = (Integer)entry.getValue();
            if (currentCount <= (previousCount = this.questory$previousInventory.getOrDefault(itemId, 0).intValue())) continue;
            int difference = currentCount - previousCount;
            class_1799 stack = new class_1799((class_1935)class_7923.field_41178.method_10223(new class_2960((String)itemId)), difference);
            QuestEvents.onItemObtained(player, stack);
        }
        this.questory$previousInventory.clear();
        this.questory$previousInventory.putAll(currentInventory);
        QuestEvents.onInventoryChanged(player);
    }

    @Unique
    private void questory$checkStatistics(class_3222 player) {
        class_3442 stats = player.method_14248();
        Set<String> requiredStats = QuestManager.getInstance().getRequiredStatistics();
        for (String statisticId : requiredStats) {
            this.questory$trackStatByName(player, stats, statisticId);
        }
    }

    @Unique
    private void questory$trackStatByName(class_3222 player, class_3442 stats, String statisticId) {
        try {
            class_3445 stat = this.questory$statCache.get(statisticId);
            if (stat == null) {
                class_2960 rl = new class_2960(statisticId);
                stat = class_3468.field_15419.method_14956((Object)rl);
                this.questory$statCache.put(statisticId, stat);
            }
            int value = stats.method_15025(stat);
            Integer last = this.questory$lastStatValues.get(statisticId);
            if (last == null || value != last) {
                this.questory$lastStatValues.put(statisticId, value);
                if (value > 0) {
                    QuestEvents.onStatisticChanged(player, statisticId, value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Questory.LOGGER.debug("[Questory Debug] PlayerMixin class loaded!");
    }
}

