/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.integration;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.texboobcat.questory.integration.OPACClaimHelper;
import org.texboobcat.questory.integration.OPACIntegration;

public class OPACPlaceholders {
    public static String process(String text, class_3222 player) {
        if (text == null || text.isEmpty() || player == null) {
            return text;
        }
        if (!text.contains("{opac_")) {
            return text;
        }
        if (!OPACClaimHelper.isAvailable()) {
            return OPACPlaceholders.processWithDefaults(text);
        }
        try {
            Map<String, Object> partyInfo = OPACIntegration.getPartyInfoForPlaceholders(player);
            text = text.replace("{opac_party_name}", OPACPlaceholders.toString(partyInfo.get("party_name")));
            text = text.replace("{opac_party_size}", OPACPlaceholders.toString(partyInfo.get("party_size")));
            text = text.replace("{opac_party_owner}", OPACPlaceholders.toString(partyInfo.get("party_owner")));
            text = text.replace("{opac_in_party}", OPACPlaceholders.toBoolean(partyInfo.get("in_party")));
            text = text.replace("{opac_is_party_owner}", OPACPlaceholders.toBoolean(partyInfo.get("is_party_owner")));
            int claimCount = OPACClaimHelper.getClaimCount(player);
            int forceloadCount = OPACClaimHelper.getForceloadCount(player);
            int claimLimit = OPACClaimHelper.getClaimLimit(player);
            int forceloadLimit = OPACClaimHelper.getForceloadLimit(player);
            text = text.replace("{opac_claim_count}", String.valueOf(claimCount));
            text = text.replace("{opac_forceload_count}", String.valueOf(forceloadCount));
            text = text.replace("{opac_claim_limit}", claimLimit >= 0 ? String.valueOf(claimLimit) : "unlimited");
            text = text.replace("{opac_forceload_limit}", forceloadLimit >= 0 ? String.valueOf(forceloadLimit) : "unlimited");
            class_3218 level = player.method_51469();
            class_2338 pos = player.method_24515();
            boolean inClaim = OPACClaimHelper.isClaimed(level, pos);
            boolean inOwnClaim = OPACClaimHelper.isClaimedBy(level, pos, player.method_5667());
            boolean inPartyClaim = OPACClaimHelper.isInPartyClaim(player);
            text = text.replace("{opac_in_claim}", String.valueOf(inClaim));
            text = text.replace("{opac_in_own_claim}", String.valueOf(inOwnClaim));
            text = text.replace("{opac_in_party_claim}", String.valueOf(inPartyClaim));
            UUID claimOwnerUuid = OPACClaimHelper.getClaimOwner(level, pos);
            String claimOwnerName = OPACClaimHelper.getClaimOwnerName(level, pos);
            text = text.replace("{opac_claim_owner}", claimOwnerName != null ? claimOwnerName : "");
            text = text.replace("{opac_claim_owner_uuid}", claimOwnerUuid != null ? claimOwnerUuid.toString() : "");
        }
        catch (Throwable t) {
            return OPACPlaceholders.processWithDefaults(text);
        }
        return text;
    }

    private static String processWithDefaults(String text) {
        text = text.replace("{opac_party_name}", "");
        text = text.replace("{opac_party_size}", "0");
        text = text.replace("{opac_party_owner}", "");
        text = text.replace("{opac_in_party}", "false");
        text = text.replace("{opac_is_party_owner}", "false");
        text = text.replace("{opac_claim_count}", "0");
        text = text.replace("{opac_forceload_count}", "0");
        text = text.replace("{opac_claim_limit}", "0");
        text = text.replace("{opac_forceload_limit}", "0");
        text = text.replace("{opac_in_claim}", "false");
        text = text.replace("{opac_in_own_claim}", "false");
        text = text.replace("{opac_in_party_claim}", "false");
        text = text.replace("{opac_claim_owner}", "");
        text = text.replace("{opac_claim_owner_uuid}", "");
        return text;
    }

    public static boolean hasPlaceholders(String text) {
        return text != null && text.contains("{opac_");
    }

    public static Map<String, String> getPlaceholderMap(class_3222 player) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!OPACClaimHelper.isAvailable() || player == null) {
            map.put("opac_party_name", "");
            map.put("opac_party_size", "0");
            map.put("opac_party_owner", "");
            map.put("opac_in_party", "false");
            map.put("opac_is_party_owner", "false");
            map.put("opac_claim_count", "0");
            map.put("opac_forceload_count", "0");
            map.put("opac_claim_limit", "0");
            map.put("opac_forceload_limit", "0");
            map.put("opac_in_claim", "false");
            map.put("opac_in_own_claim", "false");
            map.put("opac_in_party_claim", "false");
            map.put("opac_claim_owner", "");
            map.put("opac_claim_owner_uuid", "");
            return map;
        }
        try {
            Map<String, Object> partyInfo = OPACIntegration.getPartyInfoForPlaceholders(player);
            map.put("opac_party_name", OPACPlaceholders.toString(partyInfo.get("party_name")));
            map.put("opac_party_size", OPACPlaceholders.toString(partyInfo.get("party_size")));
            map.put("opac_party_owner", OPACPlaceholders.toString(partyInfo.get("party_owner")));
            map.put("opac_in_party", OPACPlaceholders.toBoolean(partyInfo.get("in_party")));
            map.put("opac_is_party_owner", OPACPlaceholders.toBoolean(partyInfo.get("is_party_owner")));
            map.put("opac_claim_count", String.valueOf(OPACClaimHelper.getClaimCount(player)));
            map.put("opac_forceload_count", String.valueOf(OPACClaimHelper.getForceloadCount(player)));
            int claimLimit = OPACClaimHelper.getClaimLimit(player);
            int forceloadLimit = OPACClaimHelper.getForceloadLimit(player);
            map.put("opac_claim_limit", claimLimit >= 0 ? String.valueOf(claimLimit) : "unlimited");
            map.put("opac_forceload_limit", forceloadLimit >= 0 ? String.valueOf(forceloadLimit) : "unlimited");
            class_3218 level = player.method_51469();
            class_2338 pos = player.method_24515();
            map.put("opac_in_claim", String.valueOf(OPACClaimHelper.isClaimed(level, pos)));
            map.put("opac_in_own_claim", String.valueOf(OPACClaimHelper.isClaimedBy(level, pos, player.method_5667())));
            map.put("opac_in_party_claim", String.valueOf(OPACClaimHelper.isInPartyClaim(player)));
            UUID claimOwnerUuid = OPACClaimHelper.getClaimOwner(level, pos);
            String claimOwnerName = OPACClaimHelper.getClaimOwnerName(level, pos);
            map.put("opac_claim_owner", claimOwnerName != null ? claimOwnerName : "");
            map.put("opac_claim_owner_uuid", claimOwnerUuid != null ? claimOwnerUuid.toString() : "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return map;
    }

    private static String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    private static String toBoolean(Object obj) {
        if (obj == null) {
            return "false";
        }
        if (obj instanceof Boolean) {
            return obj.toString();
        }
        return "false".equalsIgnoreCase(obj.toString()) ? "false" : "true";
    }

    public static String getClaimStatusText(class_3222 player) {
        if (!OPACClaimHelper.isAvailable() || player == null) {
            return "Claims: Not available (OPAC not installed)";
        }
        try {
            int claimCount = OPACClaimHelper.getClaimCount(player);
            int claimLimit = OPACClaimHelper.getClaimLimit(player);
            int forceloadCount = OPACClaimHelper.getForceloadCount(player);
            int forceloadLimit = OPACClaimHelper.getForceloadLimit(player);
            StringBuilder sb = new StringBuilder();
            sb.append("Claims: ").append(claimCount);
            if (claimLimit >= 0) {
                sb.append("/").append(claimLimit);
            }
            sb.append(" | Forceloads: ").append(forceloadCount);
            if (forceloadLimit >= 0) {
                sb.append("/").append(forceloadLimit);
            }
            return sb.toString();
        }
        catch (Throwable t) {
            return "Claims: Error retrieving data";
        }
    }

    public static String getCurrentChunkStatusText(class_3222 player) {
        if (!OPACClaimHelper.isAvailable() || player == null) {
            return "Current chunk: Unknown";
        }
        try {
            class_3218 level = player.method_51469();
            class_2338 pos = player.method_24515();
            if (!OPACClaimHelper.isClaimed(level, pos)) {
                return "Current chunk: Unclaimed wilderness";
            }
            String ownerName = OPACClaimHelper.getClaimOwnerName(level, pos);
            boolean isOwn = OPACClaimHelper.isClaimedBy(level, pos, player.method_5667());
            boolean isParty = OPACClaimHelper.isInPartyClaim(player);
            boolean isForceloaded = OPACClaimHelper.isForceloaded(level, pos);
            StringBuilder sb = new StringBuilder("Current chunk: Claimed by ");
            if (isOwn) {
                sb.append("you");
            } else if (isParty) {
                sb.append(ownerName != null ? ownerName : "party member");
                sb.append(" (party)");
            } else {
                sb.append(ownerName != null ? ownerName : "unknown");
            }
            if (isForceloaded) {
                sb.append(" [Forceloaded]");
            }
            return sb.toString();
        }
        catch (Throwable t) {
            return "Current chunk: Error retrieving data";
        }
    }
}

