/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.integration.OPACClaimHelper;
import org.texboobcat.questory.quest.Reward;

public class ClaimReward
extends Reward {
    private ClaimRewardType rewardType;
    private int claimAmount;
    private int forceloadAmount;
    private String displayName;
    private boolean useCommand;
    private String fallbackCommand;

    public ClaimReward(ClaimRewardType rewardType, int claimAmount, int forceloadAmount) {
        super("claim_reward");
        this.rewardType = rewardType;
        this.claimAmount = Math.max(0, claimAmount);
        this.forceloadAmount = Math.max(0, forceloadAmount);
        this.displayName = null;
        this.useCommand = true;
        this.fallbackCommand = null;
    }

    public ClaimReward(int claimAmount) {
        this(ClaimRewardType.BONUS_CLAIMS, claimAmount, 0);
    }

    public ClaimRewardType getRewardType() {
        return this.rewardType;
    }

    public void setRewardType(ClaimRewardType rewardType) {
        this.rewardType = rewardType;
    }

    public int getClaimAmount() {
        return this.claimAmount;
    }

    public void setClaimAmount(int claimAmount) {
        this.claimAmount = Math.max(0, claimAmount);
    }

    public int getForceloadAmount() {
        return this.forceloadAmount;
    }

    public void setForceloadAmount(int forceloadAmount) {
        this.forceloadAmount = Math.max(0, forceloadAmount);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isUseCommand() {
        return this.useCommand;
    }

    public void setUseCommand(boolean useCommand) {
        this.useCommand = useCommand;
    }

    public String getFallbackCommand() {
        return this.fallbackCommand;
    }

    public void setFallbackCommand(String fallbackCommand) {
        this.fallbackCommand = fallbackCommand;
    }

    @Override
    public void grant(class_3222 player) {
        if (!OPACClaimHelper.isAvailable()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7e[Questory] Claim reward requires Open Parties and Claims mod to be installed."));
            this.executeFallback(player);
            return;
        }
        boolean success = false;
        String playerName = player.method_7334().getName();
        if (this.useCommand) {
            success = this.grantViaCommand(player, playerName);
        }
        if (success) {
            String message = this.buildSuccessMessage();
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] " + message)));
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7e[Questory] Could not grant claim reward automatically. Please contact an admin."));
            this.executeFallback(player);
        }
    }

    private boolean grantViaCommand(class_3222 player, String playerName) {
        boolean claimsSuccess = true;
        boolean forceloadsSuccess = true;
        try {
            int result;
            int result2;
            int newBonus;
            int currentBonus;
            class_2168 source = player.method_5671().method_9206(4).method_9217();
            if ((this.rewardType == ClaimRewardType.BONUS_CLAIMS || this.rewardType == ClaimRewardType.BOTH) && this.claimAmount > 0) {
                currentBonus = this.getCurrentBonusClaims(player);
                newBonus = currentBonus + this.claimAmount;
                String claimCommand = String.format("openpac player-config %s bonus_chunk_claims %d", playerName, newBonus);
                try {
                    result2 = player.field_13995.method_3734().method_44252(source, claimCommand);
                    claimsSuccess = result2 > 0;
                }
                catch (Exception e) {
                    try {
                        claimCommand = String.format("openpartiesandclaims player-config %s bonus_chunk_claims %d", playerName, newBonus);
                        result = player.field_13995.method_3734().method_44252(source, claimCommand);
                        claimsSuccess = result > 0;
                    }
                    catch (Exception e2) {
                        claimsSuccess = false;
                    }
                }
            }
            if ((this.rewardType == ClaimRewardType.BONUS_FORCELOADS || this.rewardType == ClaimRewardType.BOTH) && this.forceloadAmount > 0) {
                currentBonus = this.getCurrentBonusForceloads(player);
                newBonus = currentBonus + this.forceloadAmount;
                String forceloadCommand = String.format("openpac player-config %s bonus_chunk_forceloads %d", playerName, newBonus);
                try {
                    result2 = player.field_13995.method_3734().method_44252(source, forceloadCommand);
                    forceloadsSuccess = result2 > 0;
                }
                catch (Exception e) {
                    try {
                        forceloadCommand = String.format("openpartiesandclaims player-config %s bonus_chunk_forceloads %d", playerName, newBonus);
                        result = player.field_13995.method_3734().method_44252(source, forceloadCommand);
                        forceloadsSuccess = result > 0;
                    }
                    catch (Exception e2) {
                        forceloadsSuccess = false;
                    }
                }
            }
            return claimsSuccess && forceloadsSuccess;
        }
        catch (Exception e) {
            Questory.LOGGER.warn("Failed to grant claim reward via command: {}", (Object)e.getMessage());
            return false;
        }
    }

    private int getCurrentBonusClaims(class_3222 player) {
        try {
            Object api = this.getOPACAPI(player);
            if (api == null) {
                return 0;
            }
            Object playerConfigManager = api.getClass().getMethod("getServerPlayerConfigs", new Class[0]).invoke(api, new Object[0]);
            if (playerConfigManager == null) {
                return 0;
            }
            Object playerConfig = playerConfigManager.getClass().getMethod("getLoadedConfig", UUID.class).invoke(playerConfigManager, player.method_5667());
            if (playerConfig == null) {
                return 0;
            }
            Object bonusClaims = playerConfig.getClass().getMethod("getFromEffectiveConfig", String.class).invoke(playerConfig, "bonus_chunk_claims");
            if (bonusClaims instanceof Number) {
                return ((Number)bonusClaims).intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private int getCurrentBonusForceloads(class_3222 player) {
        try {
            Object api = this.getOPACAPI(player);
            if (api == null) {
                return 0;
            }
            Object playerConfigManager = api.getClass().getMethod("getServerPlayerConfigs", new Class[0]).invoke(api, new Object[0]);
            if (playerConfigManager == null) {
                return 0;
            }
            Object playerConfig = playerConfigManager.getClass().getMethod("getLoadedConfig", UUID.class).invoke(playerConfigManager, player.method_5667());
            if (playerConfig == null) {
                return 0;
            }
            Object bonusForceloads = playerConfig.getClass().getMethod("getFromEffectiveConfig", String.class).invoke(playerConfig, "bonus_chunk_forceloads");
            if (bonusForceloads instanceof Number) {
                return ((Number)bonusForceloads).intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private Object getOPACAPI(class_3222 player) {
        try {
            Class<?> apiClass = Class.forName("xaero.pac.common.server.api.OpenPACServerAPI");
            return apiClass.getMethod("get", MinecraftServer.class).invoke(null, player.method_5682());
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void executeFallback(class_3222 player) {
        if (this.fallbackCommand == null || this.fallbackCommand.isEmpty()) {
            return;
        }
        try {
            String processedCommand = this.fallbackCommand.replace("{player}", player.method_7334().getName()).replace("{uuid}", player.method_5845()).replace("{claims}", String.valueOf(this.claimAmount)).replace("{forceloads}", String.valueOf(this.forceloadAmount));
            class_2168 source = player.method_5671().method_9206(4);
            player.field_13995.method_3734().method_44252(source, processedCommand);
        }
        catch (Exception e) {
            Questory.LOGGER.warn("Failed to execute fallback command: {}", (Object)e.getMessage());
        }
    }

    private String buildSuccessMessage() {
        StringBuilder sb = new StringBuilder("Received: ");
        if (this.rewardType == ClaimRewardType.BONUS_CLAIMS && this.claimAmount > 0) {
            sb.append("+").append(this.claimAmount).append(" bonus claim");
            if (this.claimAmount != 1) {
                sb.append("s");
            }
        } else if (this.rewardType == ClaimRewardType.BONUS_FORCELOADS && this.forceloadAmount > 0) {
            sb.append("+").append(this.forceloadAmount).append(" bonus forceload");
            if (this.forceloadAmount != 1) {
                sb.append("s");
            }
        } else if (this.rewardType == ClaimRewardType.BOTH) {
            if (this.claimAmount > 0) {
                sb.append("+").append(this.claimAmount).append(" claim");
                if (this.claimAmount != 1) {
                    sb.append("s");
                }
            }
            if (this.forceloadAmount > 0) {
                if (this.claimAmount > 0) {
                    sb.append(" & ");
                }
                sb.append("+").append(this.forceloadAmount).append(" forceload");
                if (this.forceloadAmount != 1) {
                    sb.append("s");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String getDisplayString() {
        if (this.displayName != null && !this.displayName.isEmpty()) {
            return this.displayName;
        }
        StringBuilder sb = new StringBuilder();
        if (this.rewardType == ClaimRewardType.BONUS_CLAIMS) {
            sb.append("+").append(this.claimAmount).append(" Bonus Claim");
            if (this.claimAmount != 1) {
                sb.append("s");
            }
        } else if (this.rewardType == ClaimRewardType.BONUS_FORCELOADS) {
            sb.append("+").append(this.forceloadAmount).append(" Bonus Forceload");
            if (this.forceloadAmount != 1) {
                sb.append("s");
            }
        } else {
            if (this.claimAmount > 0) {
                sb.append("+").append(this.claimAmount).append(" Claim");
                if (this.claimAmount != 1) {
                    sb.append("s");
                }
            }
            if (this.forceloadAmount > 0) {
                if (this.claimAmount > 0) {
                    sb.append(", ");
                }
                sb.append("+").append(this.forceloadAmount).append(" Forceload");
                if (this.forceloadAmount != 1) {
                    sb.append("s");
                }
            }
        }
        if (!OPACClaimHelper.isAvailable()) {
            sb.append(" \u00a77(requires OPAC)");
        }
        return sb.toString();
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("reward_type", this.rewardType.name());
        json.addProperty("claim_amount", (Number)this.claimAmount);
        json.addProperty("forceload_amount", (Number)this.forceloadAmount);
        if (this.displayName != null && !this.displayName.isEmpty()) {
            json.addProperty("displayName", this.displayName);
        }
        if (!this.useCommand) {
            json.addProperty("use_command", Boolean.valueOf(false));
        }
        if (this.fallbackCommand != null && !this.fallbackCommand.isEmpty()) {
            json.addProperty("fallback_command", this.fallbackCommand);
        }
        return json;
    }

    public static ClaimReward fromJson(JsonObject json) {
        ClaimRewardType rewardType = ClaimRewardType.BONUS_CLAIMS;
        if (json.has("reward_type")) {
            try {
                rewardType = ClaimRewardType.valueOf(json.get("reward_type").getAsString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        int claimAmount = json.has("claim_amount") ? json.get("claim_amount").getAsInt() : 0;
        int forceloadAmount = json.has("forceload_amount") ? json.get("forceload_amount").getAsInt() : 0;
        ClaimReward reward = new ClaimReward(rewardType, claimAmount, forceloadAmount);
        if (json.has("displayName")) {
            reward.setDisplayName(json.get("displayName").getAsString());
        }
        if (json.has("use_command")) {
            reward.setUseCommand(json.get("use_command").getAsBoolean());
        }
        if (json.has("fallback_command")) {
            reward.setFallbackCommand(json.get("fallback_command").getAsString());
        }
        return reward;
    }

    public static ClaimReward bonusClaims(int amount) {
        return new ClaimReward(ClaimRewardType.BONUS_CLAIMS, amount, 0);
    }

    public static ClaimReward bonusForceloads(int amount) {
        return new ClaimReward(ClaimRewardType.BONUS_FORCELOADS, 0, amount);
    }

    public static ClaimReward both(int claims, int forceloads) {
        return new ClaimReward(ClaimRewardType.BOTH, claims, forceloads);
    }

    public static enum ClaimRewardType {
        BONUS_CLAIMS,
        BONUS_FORCELOADS,
        BOTH;

    }
}

