/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class CraftingRequirement
extends Requirement {
    private String item;
    private int count;

    public CraftingRequirement(String item, int count) {
        super("item_craft");
        this.item = item;
        this.count = count;
    }

    public String getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.count;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        return "Craft " + current + "/" + this.count + " " + this.item;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("item", this.item);
        json.addProperty("count", (Number)this.count);
        return json;
    }

    public static CraftingRequirement fromJson(JsonObject json) {
        String item = json.get("item").getAsString();
        int count = json.get("count").getAsInt();
        return new CraftingRequirement(item, count);
    }
}

