/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import java.util.UUID;
import net.minecraft.class_3222;
import org.texboobcat.questory.api.RewardRegistry;
import org.texboobcat.questory.quest.AdvancementReward;
import org.texboobcat.questory.quest.ChoiceReward;
import org.texboobcat.questory.quest.ClaimReward;
import org.texboobcat.questory.quest.CommandReward;
import org.texboobcat.questory.quest.CurrencyReward;
import org.texboobcat.questory.quest.ItemReward;
import org.texboobcat.questory.quest.LootReward;
import org.texboobcat.questory.quest.RandomReward;
import org.texboobcat.questory.quest.ScriptReward;
import org.texboobcat.questory.quest.StageReward;
import org.texboobcat.questory.quest.TitleReward;
import org.texboobcat.questory.quest.ToastReward;
import org.texboobcat.questory.quest.XpLevelsReward;
import org.texboobcat.questory.quest.XpReward;

public abstract class Reward {
    protected String type;
    private String id;

    public Reward(String type) {
        this.type = type;
        this.id = UUID.randomUUID().toString();
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public abstract void grant(class_3222 var1);

    public abstract String getDisplayString();

    public abstract JsonObject toJson();

    public static Reward fromJson(JsonObject json) {
        Reward reward;
        String type;
        switch (type = json.get("type").getAsString()) {
            case "item": {
                Reward reward2 = ItemReward.fromJson(json);
                break;
            }
            case "xp": {
                Reward reward2 = XpReward.fromJson(json);
                break;
            }
            case "command": {
                Reward reward2 = CommandReward.fromJson(json);
                break;
            }
            case "script": {
                Reward reward2 = ScriptReward.fromJson(json);
                break;
            }
            case "title": {
                Reward reward2 = TitleReward.fromJson(json);
                break;
            }
            case "xp_levels": {
                Reward reward2 = XpLevelsReward.fromJson(json);
                break;
            }
            case "loot": {
                Reward reward2 = LootReward.fromJson(json);
                break;
            }
            case "random": {
                Reward reward2 = RandomReward.fromJson(json);
                break;
            }
            case "choice": {
                Reward reward2 = ChoiceReward.fromJson(json);
                break;
            }
            case "advancement": {
                Reward reward2 = AdvancementReward.fromJson(json);
                break;
            }
            case "toast": {
                Reward reward2 = ToastReward.fromJson(json);
                break;
            }
            case "stage": {
                Reward reward2 = StageReward.fromJson(json);
                break;
            }
            case "currency": {
                Reward reward2 = CurrencyReward.fromJson(json);
                break;
            }
            case "claim_reward": {
                Reward reward2 = ClaimReward.fromJson(json);
                break;
            }
            default: {
                Reward reward2 = reward = null;
            }
        }
        if (reward == null && RewardRegistry.isRegistered(type)) {
            reward = RewardRegistry.create(type, json);
        }
        if (reward == null) {
            throw new IllegalArgumentException("Unknown reward type: " + type);
        }
        if (json.has("id")) {
            reward.setId(json.get("id").getAsString());
        }
        return reward;
    }
}

