/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.texboobcat.questory.integration.GameStagesHelper;
import org.texboobcat.questory.quest.Reward;

public class StageReward
extends Reward {
    private String stage;
    private boolean remove;

    public StageReward(String stage, boolean remove) {
        super("stage");
        this.stage = stage;
        this.remove = remove;
    }

    public String getStage() {
        return this.stage;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    @Override
    public void grant(class_3222 player) {
        if (!GameStagesHelper.isAvailable()) {
            System.err.println("[Questory] Cannot " + (this.remove ? "remove" : "grant") + " stage '" + this.stage + "' - GameStages mod not installed");
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7c[Questory] GameStages mod required for stage reward: " + this.stage)));
            return;
        }
        if (this.remove) {
            GameStagesHelper.getInstance().removeStage(player, this.stage);
            System.out.println("[Questory] Removed stage '" + this.stage + "' from " + player.method_5477().getString());
        } else {
            GameStagesHelper.getInstance().addStage(player, this.stage);
            System.out.println("[Questory] Granted stage '" + this.stage + "' to " + player.method_5477().getString());
        }
    }

    @Override
    public String getDisplayString() {
        return (this.remove ? "Remove" : "Grant") + " stage: " + this.stage;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "stage");
        json.addProperty("stage", this.stage);
        if (this.remove) {
            json.addProperty("remove", Boolean.valueOf(true));
        }
        return json;
    }

    public static StageReward fromJson(JsonObject json) {
        String stage = json.get("stage").getAsString();
        boolean remove = json.has("remove") && json.get("remove").getAsBoolean();
        return new StageReward(stage, remove);
    }
}

